/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraphTrackActive;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.SysTxnState;
import org.apache.jena.tdb.transaction.TDBTransactionException;

public class DatasetGraphTransaction
extends DatasetGraphTrackActive
implements Sync {
    private ThreadLocal<DatasetGraphTxn> txn = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> false);
    private final StoreConnection sConn;
    private boolean isClosed = false;

    public DatasetGraphTransaction(Location location) {
        this.sConn = StoreConnection.make(location);
    }

    public Location getLocation() {
        return this.sConn.getLocation();
    }

    public DatasetGraphTDB getDatasetGraphToQuery() {
        this.checkNotClosed();
        return this.get();
    }

    public DatasetGraphTDB getBaseDatasetGraph() {
        this.checkNotClosed();
        return this.sConn.getBaseDataset();
    }

    public DatasetGraphTDB get() {
        if (this.isInTransaction()) {
            DatasetGraphTxn dsgTxn = this.txn.get();
            if (dsgTxn == null) {
                throw new TDBTransactionException("In a transaction but no transactional DatasetGraph");
            }
            return dsgTxn.getView();
        }
        if (this.sConn.haveUsedInTransaction()) {
            throw new TDBTransactionException("Not in a transaction");
        }
        return this.sConn.getBaseDataset();
    }

    protected void checkActive() {
        this.checkNotClosed();
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction (" + this.getLocation() + ")");
        }
    }

    protected void checkNotActive() {
        this.checkNotClosed();
        if (this.sConn.haveUsedInTransaction() && this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction (" + this.getLocation() + ")");
        }
    }

    protected void checkNotClosed() {
        if (this.isClosed) {
            throw new JenaTransactionException("Already closed");
        }
    }

    public boolean isInTransaction() {
        this.checkNotClosed();
        return this.inTransaction.get();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void syncIfNotTransactional() {
        if (!this.sConn.haveUsedInTransaction()) {
            this.sConn.getBaseDataset().sync();
        }
    }

    protected void _begin(ReadWrite readWrite) {
        this.checkNotClosed();
        DatasetGraphTxn dsgTxn = this.sConn.begin(readWrite);
        this.txn.set(dsgTxn);
        this.inTransaction.set(true);
    }

    protected void _commit() {
        this.checkNotClosed();
        this.txn.get().commit();
        this.inTransaction.set(false);
    }

    protected void _abort() {
        this.checkNotClosed();
        this.txn.get().abort();
        this.inTransaction.set(false);
    }

    protected void _end() {
        this.checkNotClosed();
        DatasetGraphTxn dsg = this.txn.get();
        if (dsg == null) {
            TDB.logInfo.warn("Transaction already ended");
            return;
        }
        this.txn.get().end();
        this.inTransaction.set(false);
        this.txn.set(null);
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionAbort() {
        return true;
    }

    public String toString() {
        try {
            if (this.isInTransaction()) {
                return this.get().toString();
            }
            return this.getBaseDatasetGraph().toString();
        }
        catch (Throwable th) {
            return "DatasetGraphTransaction";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close() {
        if (this.isClosed) {
            return;
        }
        if (!this.sConn.haveUsedInTransaction()) {
            DatasetGraphTransaction datasetGraphTransaction = this;
            synchronized (datasetGraphTransaction) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                if (!this.sConn.isValid()) {
                    return;
                }
                DatasetGraphTDB dsg = this.sConn.getBaseDataset();
                dsg.sync();
                dsg.close();
                StoreConnection.release(this.getLocation());
                return;
            }
        }
        if (this.isInTransaction()) {
            TDB.logInfo.warn("Attempt to close a DatasetGraphTransaction while a transaction is active - ignored close (" + this.getLocation() + ")");
            return;
        }
        this.txn.remove();
        this.inTransaction.remove();
        this.isClosed = true;
    }

    public Context getContext() {
        return this.getBaseDatasetGraph().getContext();
    }

    public SysTxnState getTransMgrState() {
        return this.sConn.getTransMgrState();
    }

    public void sync() {
        if (!this.sConn.haveUsedInTransaction() && this.get() != null) {
            this.get().sync();
        }
    }
}

