/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.nodetable;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.index.Index;
import org.apache.jena.tdb.lib.NodeLib;
import org.apache.jena.tdb.store.Hash;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;

public class NodeTableNative
implements NodeTable {
    protected ObjectFile objects;
    protected Index nodeHashToId;
    private boolean syncNeeded = false;

    protected NodeTableNative() {
    }

    public NodeTableNative(Index nodeToId, ObjectFile objectFile) {
        this();
        this.init(nodeToId, objectFile);
    }

    protected void init(Index nodeToId, ObjectFile objectFile) {
        this.nodeHashToId = nodeToId;
        this.objects = objectFile;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    @Override
    public boolean containsNode(Node node) {
        NodeId x = this.getNodeIdForNode(node);
        return NodeId.isDoesNotExist(x);
    }

    @Override
    public boolean containsNodeId(NodeId nodeId) {
        Node x = this.getNodeForNodeId(nodeId);
        return x == null;
    }

    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        Node n = this.readNodeFromTable(id);
        return n;
    }

    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeId nodeId = this.accessIndex(node, allocate);
        return nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NodeId accessIndex(Node node, boolean create) {
        Hash hash = new Hash(this.nodeHashToId.getRecordFactory().keyLength());
        NodeLib.setHash(hash, node);
        byte[] k = hash.getBytes();
        Record r = this.nodeHashToId.getRecordFactory().create(k);
        NodeTableNative nodeTableNative = this;
        synchronized (nodeTableNative) {
            Record r2 = this.nodeHashToId.find(r);
            if (r2 != null) {
                NodeId id = NodeId.create(r2.getValue(), 0);
                return id;
            }
            if (!create) {
                return NodeId.NodeDoesNotExist;
            }
            NodeId id = this.writeNodeToTable(node);
            id.toBytes(r.getValue(), 0);
            if (!this.nodeHashToId.add(r)) {
                throw new TDBException("NodeTableBase::nodeToId - record mysteriously appeared");
            }
            return id;
        }
    }

    private final NodeId writeNodeToTable(Node node) {
        this.syncNeeded = true;
        long x = NodeLib.encodeStore(node, this.getObjects());
        return NodeId.create(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node readNodeFromTable(NodeId id) {
        NodeTableNative nodeTableNative = this;
        synchronized (nodeTableNative) {
            if (id.getId() >= this.getObjects().length()) {
                return null;
            }
            return NodeLib.fetchDecode(id.getId(), this.getObjects());
        }
    }

    public synchronized void close() {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.close();
            this.nodeHashToId = null;
        }
        if (this.getObjects() != null) {
            this.getObjects().close();
            this.objects = null;
        }
    }

    @Override
    public NodeId allocOffset() {
        return NodeId.create(this.getObjects().length());
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return this.all2();
    }

    private Iterator<Pair<NodeId, Node>> all2() {
        Iterator<Pair<Long, ByteBuffer>> objs = this.objects.all();
        Function<Pair, Pair> transform = item -> {
            NodeId id = NodeId.create((Long)item.car());
            ByteBuffer bb = (ByteBuffer)item.cdr();
            Node n = NodeLib.decode(bb);
            return new Pair((Object)id, (Object)n);
        };
        return Iter.map(objs, transform);
    }

    public void sync() {
        if (this.syncNeeded) {
            if (this.nodeHashToId != null) {
                this.nodeHashToId.sync();
            }
            if (this.getObjects() != null) {
                this.getObjects().sync();
            }
            this.syncNeeded = false;
        }
    }

    public ObjectFile getObjects() {
        return this.objects;
    }

    public String toString() {
        return this.objects.getLabel();
    }

    @Override
    public boolean isEmpty() {
        return this.getObjects().isEmpty();
    }

    @Override
    public NodeTable wrapped() {
        return null;
    }
}

