/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNotSupported;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.lib.NodeLib;
import org.apache.jena.tdb.store.DatasetPrefixesTDB;
import org.apache.jena.tdb.store.GraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.QuadTable;
import org.apache.jena.tdb.store.StorageConfig;
import org.apache.jena.tdb.store.TripleTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;

public final class DatasetGraphTDB
extends DatasetGraphTriplesQuads
implements Sync,
Closeable {
    private TripleTable tripleTable;
    private QuadTable quadTable;
    private DatasetPrefixesTDB prefixes;
    private final ReorderTransformation transform;
    private final StorageConfig config;
    private GraphTDB effectiveDefaultGraph;
    private boolean closed = false;
    private static final int sliceSize = 1000;
    private final Transactional txn = new TransactionalNotSupported();

    public DatasetGraphTDB(TripleTable tripleTable, QuadTable quadTable, DatasetPrefixesTDB prefixes, ReorderTransformation transform, StorageConfig config) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
        this.prefixes = prefixes;
        this.transform = transform;
        this.config = config;
        this.effectiveDefaultGraph = this.getDefaultGraphTDB();
    }

    public QuadTable getQuadTable() {
        return this.quadTable;
    }

    public TripleTable getTripleTable() {
        return this.tripleTable;
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return GraphUtils.triples2quadsDftGraph(this.getTripleTable().find(s, p, o));
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return this.getQuadTable().find(g, s, p, o);
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return this.getQuadTable().find(Node.ANY, s, p, o);
    }

    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().add(s, p, o);
    }

    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().add(g, s, p, o);
    }

    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().delete(s, p, o);
    }

    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().delete(g, s, p, o);
    }

    public GraphTDB getDefaultGraphTDB() {
        return (GraphTDB)this.getDefaultGraph();
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        return (GraphTDB)this.getGraph(graphNode);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.tripleTable.close();
        this.quadTable.close();
        this.prefixes.close();
        this.tripleTable = null;
        this.quadTable = null;
        this.prefixes = null;
    }

    public boolean containsGraph(Node graphNode) {
        if (Quad.isDefaultGraphExplicit((Node)graphNode) || Quad.isUnionGraph((Node)graphNode)) {
            return true;
        }
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().findAsNodeIds(graphNode, null, null, null);
        if (x == null) {
            return false;
        }
        boolean result = x.hasNext();
        return result;
    }

    public Graph getDefaultGraph() {
        return new GraphTDB(this, null);
    }

    public Graph getGraph(Node graphNode) {
        return new GraphTDB(this, graphNode);
    }

    public GraphTDB getEffectiveDefaultGraph() {
        return this.effectiveDefaultGraph;
    }

    public StorageConfig getConfig() {
        return this.config;
    }

    public ReorderTransformation getReorderTransform() {
        return this.transform;
    }

    public DatasetPrefixesTDB getPrefixes() {
        return this.prefixes;
    }

    public Iterator<Node> listGraphNodes() {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().findAll();
        Iter z = Iter.iter(x).map(t -> (NodeId)t.get(0)).distinct();
        return NodeLib.nodes(this.quadTable.getNodeTupleTable().getNodeTable(), (Iterator<NodeId>)z);
    }

    public long size() {
        return Iter.count(this.listGraphNodes());
    }

    public boolean isEmpty() {
        return this.getTripleTable().isEmpty() && this.getQuadTable().isEmpty();
    }

    public void clear() {
        this.getTripleTable().clearTriples();
        this.getQuadTable().clearQuads();
    }

    public NodeTupleTable chooseNodeTupleTable(Node graphNode) {
        if (graphNode == null || Quad.isDefaultGraph((Node)graphNode)) {
            return this.getTripleTable().getNodeTupleTable();
        }
        return this.getQuadTable().getNodeTupleTable();
    }

    public void deleteAny(Node g, Node s, Node p, Node o) {
        int len;
        NodeTupleTable t = this.chooseNodeTupleTable(g);
        Tuple[] array = new Tuple[1000];
        do {
            Iterator<Tuple<NodeId>> iter = null;
            iter = g == null ? t.findAsNodeIds(s, p, o) : t.findAsNodeIds(g, s, p, o);
            if (iter == null) {
                return;
            }
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                t.getTupleTable().delete((Tuple<NodeId>)array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
    }

    public Location getLocation() {
        return this.config.location;
    }

    public void sync() {
        this.tripleTable.sync();
        this.quadTable.sync();
        this.prefixes.sync();
    }

    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("Can't set default graph via GraphStore on a TDB-backed dataset");
    }

    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    public void commit() {
        this.txn.commit();
    }

    public void abort() {
        this.txn.abort();
    }

    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    public void end() {
        this.txn.end();
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionAbort() {
        return false;
    }
}

