/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.lib;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class ShLib {
    private static String PREFIXES = StrUtils.strjoinNL((String[])new String[]{"PREFIX owl:  <http://www.w3.org/2002/07/owl#>", "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX sh:   <http://www.w3.org/ns/shacl#>", "PREFIX xsd:  <http://www.w3.org/2001/XMLSchema#>", ""});
    private static PrefixMap pmap = PrefixMapFactory.createForOutput();
    private static NodeFormatter nodeFmt;

    public static void printShapes(Graph shapeGraph) {
        ShLib.printShapes(Shapes.parse(shapeGraph));
    }

    public static void printShapes(Shapes shapes) {
        IndentedWriter out = IndentedWriter.stdout;
        ShLib.printShapes(out, shapes);
    }

    public static void printShapes(IndentedWriter out, Shapes shapes) {
        int indent = out.getAbsoluteIndent();
        for (Shape shape : shapes) {
            shape.print(out);
        }
        out.setAbsoluteIndent(indent);
    }

    public static void print(Collection<Node> nodes) {
        nodes.stream().forEach(n -> {
            if (n.isURI()) {
                System.out.println(n.getLocalName());
            } else {
                System.out.println(ShLib.displayStr(n));
            }
        });
    }

    public static void printReport(ValidationReport report) {
        ShLib.printReport(System.out, report);
    }

    public static void printReport(OutputStream output, ValidationReport report) {
        PrintStream out;
        PrintStream printStream = out = output instanceof PrintStream ? (PrintStream)output : new PrintStream(output);
        if (report.conforms()) {
            out.println("Conforms");
            out.flush();
            return;
        }
        try {
            report.getEntries().forEach(e -> {
                out.printf("Node=%s\n", ShLib.displayStr(e.focusNode()));
                if (e.resultPath() != null) {
                    out.printf("  Path=%s\n", e.resultPath());
                }
                if (e.value() != null) {
                    out.printf("  Value: %s\n", ShLib.displayStr(e.value()));
                }
                if (e.message() != null) {
                    out.printf("  Message: %s\n", e.message());
                }
            });
        }
        finally {
            out.flush();
        }
    }

    public static void printReport(Resource report) {
        String qs = StrUtils.strjoinNL((String[])new String[]{PREFIXES, "SELECT * {", "    [] sh:result ?R .", "    ?R", "       sh:focusNode ?focusNode ;", "       sh:resultMessage ?message ;", "       sh:resultSeverity  ?severity ; ", "       .", "    OPTIONAL { ?R sh:sourceConstraintComponent ?component }", "    OPTIONAL { ?R sh:sourceShape ?sourceShape }", "    OPTIONAL { ?R sh:resultPath    ?path}", "}"});
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Model)report.getModel());){
            ResultSet rs = qExec.execSelect();
            if (!rs.hasNext()) {
                System.out.println("No violations");
            } else {
                rs.forEachRemaining(row -> {
                    RDFNode focusNode = row.get("focusNode");
                    String msg = row.getLiteral("message").getLexicalForm();
                    RDFNode pathNode = row.get("path");
                    if (pathNode != null) {
                        System.out.printf("Node=%s   Path=%s\n", ShLib.displayStr(focusNode), pathNode);
                    } else {
                        System.out.printf("Node=%s\n", ShLib.displayStr(focusNode));
                    }
                    System.out.printf("  %s\n", msg);
                    Path path = null;
                    if (pathNode != null) {
                        path = ShaclPaths.parsePath(report.getModel().getGraph(), pathNode.asNode());
                    }
                });
            }
        }
    }

    static String displayStr(RDFNode n) {
        return ShLib.displayStr(n.asNode(), nodeFmt);
    }

    public static String displayStr(Node n) {
        return ShLib.displayStr(n, nodeFmt);
    }

    public static String displayStr(Node n, NodeFormatter fmt) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        nodeFmt.format((AWriter)sw, n);
        return sw.toString();
    }

    public static boolean isImmediate(Target target) {
        TargetType targetType = target.getTargetType();
        return targetType.equals((Object)TargetType.targetObjectsOf) || targetType.equals((Object)TargetType.targetSubjectsOf);
    }

    public static Node focusNode(Triple triple, Target target) {
        switch (target.getTargetType()) {
            case targetNode: {
                return target.getObject();
            }
            case targetObjectsOf: {
                return triple.getObject();
            }
            case targetSubjectsOf: {
                return triple.getSubject();
            }
        }
        return null;
    }

    static {
        pmap.add("owl", OWL.getURI());
        pmap.add("rdf", RDF.getURI());
        pmap.add("rdfs", RDFS.getURI());
        pmap.add("sh", SHACL.getURI());
        pmap.add("xsd", XSD.getURI());
        nodeFmt = new NodeFormatterTTL(null, pmap);
    }
}

