/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;

public class ResultsStAX
implements ResultSet,
Closeable {
    private QuerySolution current = null;
    private XMLStreamReader parser = null;
    private List<String> variables = new ArrayList<String>();
    private Binding binding = null;
    private boolean inputGraphLabels = ARQ.isTrue(ARQ.inputGraphBNodeLabels);
    private final LabelToNode bNodes;
    private boolean isResultSet = false;
    private boolean ordered = false;
    private boolean distinct = false;
    private boolean finished = false;
    private Model model = null;
    private int row = 0;
    private boolean askResult = false;
    static final String XML_NS = "http://www.w3.org/XML/1998/namespace";

    public static SPARQLResult read(InputStream in, Model model, Context context2) {
        XMLInputFactory xf = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xReader = xf.createXMLStreamReader(in);
            return ResultsStAX.worker(xReader, model, context2);
        }
        catch (XMLStreamException e2) {
            throw new ResultSetException("Can't initialize StAX parsing engine", e2);
        }
        catch (Exception ex) {
            throw new ResultSetException("Failed when initializing the StAX parsing engine", ex);
        }
    }

    public static SPARQLResult read(Reader in, Model model, Context context2) {
        XMLInputFactory xf = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xReader = xf.createXMLStreamReader(in);
            return ResultsStAX.worker(xReader, model, context2);
        }
        catch (XMLStreamException e2) {
            throw new ResultSetException("Can't initialize StAX parsing engine", e2);
        }
        catch (Exception ex) {
            throw new ResultSetException("Failed when initializing the StAX parsing engine", ex);
        }
    }

    private static SPARQLResult worker(XMLStreamReader xReader, Model model, Context context2) {
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        ResultsStAX rss = new ResultsStAX(xReader, model, context2);
        return rss.read();
    }

    private ResultsStAX(XMLStreamReader reader, Model model, Context context2) {
        this.parser = reader;
        this.model = model;
        boolean inputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.inputGraphBNodeLabels);
        this.bNodes = inputGraphBNodeLabels ? SyntaxLabels.createLabelToNodeAsGiven() : SyntaxLabels.createLabelToNode();
        this.init();
    }

    private SPARQLResult read() {
        if (this.isResultSet) {
            return new SPARQLResult(this);
        }
        return new SPARQLResult(this.askResult);
    }

    private void init() {
        try {
            this.skipTo("head");
            this.processHead();
            this.skipTo(new String[]{"results", "boolean"}, new String[]{"results"});
            String tag = this.parser.getLocalName();
            if (tag.equals("results")) {
                this.isResultSet = true;
                this.processResults();
            }
            if (tag.equals("boolean")) {
                this.isResultSet = false;
                this.processBoolean();
            }
        }
        catch (XMLStreamException ex) {
            Log.warn((Object)this, (String)("XMLStreamException: " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public boolean hasNext() {
        boolean b;
        if (!this.isResultSet) {
            throw new ResultSetException("Not an XML result set");
        }
        if (this.finished) {
            return false;
        }
        try {
            if (this.binding == null) {
                this.binding = this.getOneSolution();
            }
        }
        catch (XMLStreamException ex) {
            this.staxError("XMLStreamException: " + ex.getMessage(), ex);
        }
        boolean bl = b = this.binding != null;
        if (!b) {
            this.close();
        }
        return b;
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    @Override
    public Binding nextBinding() {
        if (this.finished) {
            throw new NoSuchElementException("End of XML Results");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("End of XML Results");
        }
        Binding r = this.binding;
        ++this.row;
        this.binding = null;
        return r;
    }

    @Override
    public QuerySolution nextSolution() {
        Binding r = this.nextBinding();
        ResultBinding currentEnv = new ResultBinding(this.model, r);
        return currentEnv;
    }

    @Override
    public int getRowNumber() {
        return this.row;
    }

    @Override
    public List<String> getResultVars() {
        return this.variables;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Model getResourceModel() {
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(ResultsStAX.class.getName());
    }

    public void close() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        try {
            this.parser.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void processBoolean() throws XMLStreamException {
        try {
            String s = this.parser.getElementText();
            if (s.equalsIgnoreCase("true")) {
                this.askResult = true;
                return;
            }
            if (s.equalsIgnoreCase("false")) {
                this.askResult = false;
                return;
            }
            throw new ResultSetException("Unknown boolean value: " + s);
        }
        finally {
            this.close();
        }
    }

    private void skipTo(String tag1) throws XMLStreamException {
        this.skipTo(new String[]{tag1}, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipTo(String[] startElementNames, String[] stopElementNames) throws XMLStreamException {
        boolean found = false;
        block5: while (this.parser.hasNext()) {
            int event = this.parser.next();
            switch (event) {
                case 8: {
                    break block5;
                }
                case 2: {
                    String endTag;
                    if (stopElementNames == null || (endTag = this.parser.getLocalName()) == null || !this.containsName(stopElementNames, endTag)) break;
                    return;
                }
                case 1: {
                    if (startElementNames == null) break;
                    QName qname = this.parser.getName();
                    if (!qname.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
                        this.staxError("skipToHead: Unexpected tag: " + qname);
                    }
                    if (!this.containsName(startElementNames, qname.getLocalPart())) break;
                    return;
                }
            }
        }
        if (!found) {
            String s1 = "";
            if (startElementNames != null) {
                s1 = String.join((CharSequence)", ", startElementNames);
            }
            String s2 = "";
            if (stopElementNames != null) {
                s2 = String.join((CharSequence)", ", stopElementNames);
            }
            Log.warn((Object)this, (String)("Failed to find start and stop of specified elements: " + s1 + " :: " + s2));
        }
    }

    private boolean containsName(String[] elementNames, String eName) {
        for (String s : elementNames) {
            if (!s.equals(eName)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processHead() throws XMLStreamException {
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            String tag = null;
            switch (event) {
                case 8: {
                    return;
                }
                case 2: {
                    tag = this.parser.getLocalName();
                    if (!this.isTag(tag, "head")) break;
                    return;
                }
                case 1: {
                    tag = this.parser.getLocalName();
                    if (this.isTag(tag, "head")) break;
                    if (this.isTag(tag, "variable")) {
                        String varname = this.parser.getAttributeValue(null, "name");
                        this.variables.add(varname);
                        break;
                    }
                    if (this.isTag(tag, "link")) break;
                    this.staxError("Unknown XML element: " + tag);
                }
            }
        }
    }

    private void processResults() {
    }

    private Binding getOneSolution() throws XMLStreamException {
        if (this.finished) {
            return null;
        }
        BindingMap binding = BindingFactory.create();
        String varName = null;
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            String tag = null;
            switch (event) {
                case 8: {
                    this.staxError("End of document while processing solution");
                    return null;
                }
                case 2: {
                    tag = this.parser.getLocalName();
                    if (this.isTag(tag, "result")) {
                        return binding;
                    }
                    if (!this.isTag(tag, "results")) break;
                    return null;
                }
                case 1: {
                    Node node;
                    tag = this.parser.getLocalName();
                    if (this.isTag(tag, "result")) {
                        binding = BindingFactory.create();
                        break;
                    }
                    if (this.isTag(tag, "binding")) {
                        varName = this.parser.getAttributeValue(null, "name");
                        break;
                    }
                    if (this.isTag(tag, "bnode")) {
                        String label = this.parser.getElementText();
                        node = null;
                        node = this.inputGraphLabels ? NodeFactory.createBlankNode((String)label) : (Node)this.bNodes.get(null, label);
                        ResultsStAX.addBinding(binding, Var.alloc(varName), node);
                        break;
                    }
                    if (this.isTag(tag, "literal")) {
                        String datatype = this.parser.getAttributeValue(null, "datatype");
                        String langTag = this.parser.getAttributeValue(XML_NS, "lang");
                        String text = this.parser.getElementText();
                        RDFDatatype dType = null;
                        if (datatype != null) {
                            dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
                        }
                        Node n = NodeFactory.createLiteral((String)text, (String)langTag, (RDFDatatype)dType);
                        if (varName == null) {
                            throw new ResultSetException("No name for variable");
                        }
                        ResultsStAX.addBinding(binding, Var.alloc(varName), n);
                        break;
                    }
                    if (this.isTag(tag, "unbound") || !this.isTag(tag, "uri")) break;
                    String uri = this.parser.getElementText();
                    node = NodeFactory.createURI((String)uri);
                    ResultsStAX.addBinding(binding, Var.alloc(varName), node);
                    break;
                }
            }
        }
        this.staxError("getOneSolution: Hit end unexpectedly");
        return null;
    }

    protected static void addBinding(BindingMap binding, Var var, Node value) {
        Node n = binding.get(var);
        if (n != null) {
            if (n.equals((Object)value)) {
                return;
            }
            Log.warn(ResultsStAX.class, (String)String.format("Multiple occurences of a binding for variable '%s' with different values - ignored", var.getName()));
            return;
        }
        binding.add(var, value);
    }

    private boolean isTag(String localName, String expectedName) {
        if (!this.parser.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
            return false;
        }
        return localName.equals(expectedName);
    }

    private void staxError(String msg) {
        Log.warn((Object)this, (String)("StAX error: " + msg));
        throw new ResultSetException(msg);
    }

    private void staxError(String msg, Throwable th) {
        Log.warn((Object)this, (String)("StAX error: " + msg), (Throwable)th);
        throw new ResultSetException(msg, th);
    }
}

