/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.functions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.Uris;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.functions.ParseContainerFromHeaders;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectListFromResponse
implements Function<HttpResponse, ObjectList>,
InvocationContext<ParseObjectListFromResponse> {
    private final ParseJson<List<InternalObject>> json;
    private final ParseContainerFromHeaders parseContainer;
    private ToSwiftObject toSwiftObject;

    @Inject
    ParseObjectListFromResponse(ParseJson<List<InternalObject>> json, ParseContainerFromHeaders parseContainer) {
        this.json = json;
        this.parseContainer = parseContainer;
    }

    public ObjectList apply(HttpResponse from) {
        List objects = Lists.transform((List)((List)this.json.apply(from)), (Function)this.toSwiftObject);
        Container container = this.parseContainer.apply(from);
        return ObjectList.create(objects, container);
    }

    public ParseObjectListFromResponse setContext(HttpRequest request) {
        this.parseContainer.name = ((Invocation)((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getCaller().get()).getArgs().get(1).toString();
        String containerUri = request.getEndpoint().toString();
        int queryIndex = containerUri.indexOf(63);
        if (queryIndex != -1) {
            containerUri = containerUri.substring(0, queryIndex);
        }
        this.toSwiftObject = new ToSwiftObject(containerUri);
        return this;
    }

    private static Payload payload(long bytes, String hash, String contentType, Date expires) {
        ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)ByteSource.empty());
        payload.getContentMetadata().setContentLength(Long.valueOf(bytes));
        payload.getContentMetadata().setContentType(contentType);
        payload.getContentMetadata().setExpires(expires);
        if (hash != null) {
            payload.getContentMetadata().setContentMD5(HashCode.fromBytes((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)hash)));
        }
        return payload;
    }

    static class ToSwiftObject
    implements Function<InternalObject, SwiftObject> {
        private final String containerUri;

        ToSwiftObject(String containerUri) {
            this.containerUri = containerUri;
        }

        public SwiftObject apply(InternalObject input) {
            return SwiftObject.builder().uri(Uris.uriBuilder((CharSequence)this.containerUri).clearQuery().appendPath(input.name).build()).name(input.name).etag(input.hash).payload(ParseObjectListFromResponse.payload(input.bytes, input.hash, input.content_type, input.expires)).lastModified(input.last_modified).build();
        }
    }

    private static final class InternalObject {
        String name;
        String hash;
        long bytes;
        String content_type;
        Date last_modified;
        Date expires;

        private InternalObject() {
        }
    }
}

