/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;

public class Account {
    private final long containerCount;
    private final long objectCount;
    private final long bytesUsed;
    private final Map<String, String> metadata;
    private final Multimap<String, String> headers;

    protected Account(long containerCount, long objectCount, long bytesUsed, Map<String, String> metadata, Multimap<String, String> headers) {
        this.containerCount = containerCount;
        this.objectCount = objectCount;
        this.bytesUsed = bytesUsed;
        this.metadata = metadata == null ? ImmutableMap.of() : metadata;
        this.headers = headers == null ? ImmutableMultimap.of() : headers;
    }

    public long getContainerCount() {
        return this.containerCount;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public Optional<String> getTemporaryUrlKey() {
        return Optional.fromNullable((Object)this.metadata.get("temp-url-key"));
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Account) {
            Account that = (Account)Account.class.cast(object);
            return Objects.equal((Object)this.getContainerCount(), (Object)that.getContainerCount()) && Objects.equal((Object)this.getObjectCount(), (Object)that.getObjectCount()) && Objects.equal((Object)this.getBytesUsed(), (Object)that.getBytesUsed()) && Objects.equal(this.getMetadata(), that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getContainerCount(), this.getObjectCount(), this.getBytesUsed(), this.getMetadata()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("containerCount", this.getContainerCount()).add("objectCount", this.getObjectCount()).add("bytesUsed", this.getBytesUsed()).add("metadata", this.getMetadata());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Account.builder().fromAccount(this);
    }

    public static class Builder {
        protected long containerCount;
        protected long objectCount;
        protected long bytesUsed;
        protected Multimap<String, String> headers = ImmutableMultimap.of();
        protected Map<String, String> metadata = ImmutableMap.of();

        public Builder containerCount(long containerCount) {
            this.containerCount = containerCount;
            return this;
        }

        public Builder objectCount(long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public Builder bytesUsed(long bytesUsed) {
            this.bytesUsed = bytesUsed;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")).entrySet()) {
                builder.put((Object)((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
            this.metadata = builder.build();
            return this;
        }

        public Builder headers(Multimap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Account build() {
            return new Account(this.containerCount, this.objectCount, this.bytesUsed, this.metadata, this.headers);
        }

        public Builder fromAccount(Account from) {
            return this.containerCount(from.getContainerCount()).objectCount(from.getObjectCount()).bytesUsed(from.getBytesUsed()).metadata(from.getMetadata()).headers(from.getHeaders());
        }
    }
}

