/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.internal.BoundedLinkedHashSet;
import org.jclouds.atmos.xml.ListDirectoryResponseHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;

@Singleton
public class ParseDirectoryListFromContentAndHeaders
implements Function<HttpResponse, BoundedSet<DirectoryEntry>> {
    private final ParseSax.Factory factory;
    private final Provider<ListDirectoryResponseHandler> listHandlerProvider;

    @Inject
    ParseDirectoryListFromContentAndHeaders(ParseSax.Factory factory, Provider<ListDirectoryResponseHandler> listHandlerProvider) {
        this.factory = (ParseSax.Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        this.listHandlerProvider = (Provider)Preconditions.checkNotNull(listHandlerProvider, (Object)"listHandlerProvider");
    }

    public BoundedSet<DirectoryEntry> apply(HttpResponse from) {
        Preconditions.checkNotNull((Object)from, (Object)"http response");
        String token = from.getFirstHeaderOrNull("x-emc-token");
        return new BoundedLinkedHashSet<DirectoryEntry>((Iterable)this.factory.create((ParseSax.HandlerWithResult)this.listHandlerProvider.get()).parse(from.getPayload().getInput()), token);
    }
}

