/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

public final class QueryUtils {
    private QueryUtils() {
    }

    @NotNull
    public static String escapeNodeName(@NotNull String string) {
        int j;
        StringBuilder result = new StringBuilder();
        int k = 0;
        do {
            if ((j = string.indexOf(37, k)) < 0) {
                result.append(Text.escapeIllegalJcrChars((String)string.substring(k)));
            } else if (j > 0 && string.charAt(j - 1) == '\\') {
                result.append(Text.escapeIllegalJcrChars((String)(string.substring(k, j) + '%')));
            } else {
                result.append(Text.escapeIllegalJcrChars((String)string.substring(k, j))).append('%');
            }
            k = j + 1;
        } while (j >= 0);
        return result.toString();
    }

    @NotNull
    public static String escapeForQuery(@NotNull String value) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\'') {
                ret.append("''");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

