/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.header.OverwriteHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger((Class)CopyMethod.class);

    public CopyMethod(String uri, String destinationUri, boolean overwrite) {
        this(uri, destinationUri, overwrite, false);
    }

    public CopyMethod(String uri, String destinationUri, boolean overwrite, boolean shallow) {
        super(uri);
        this.setRequestHeader("Destination", destinationUri);
        this.setRequestHeader(new OverwriteHeader(overwrite));
        if (shallow) {
            this.setRequestHeader(new DepthHeader(false));
        }
    }

    public String getName() {
        return "COPY";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 201 || statusCode == 204;
    }
}

