/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.springdata20.repository.IgniteRepository;
import org.apache.ignite.springdata20.repository.support.ConditionFalse;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ConditionFalse.class})
public class IgniteRepositoryImpl<T, ID extends Serializable>
implements IgniteRepository<T, ID> {
    private final IgniteCache<ID, T> cache;

    public IgniteRepositoryImpl(IgniteCache<ID, T> cache) {
        this.cache = cache;
    }

    @Override
    public <S extends T> S save(ID key, S entity) {
        this.cache.put(key, entity);
        return entity;
    }

    @Override
    public <S extends T> Iterable<S> save(Map<ID, S> entities) {
        this.cache.putAll(entities);
        return entities.values();
    }

    public <S extends T> S save(S entity) {
        throw new UnsupportedOperationException("Use IgniteRepository.save(key,value) method instead.");
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        throw new UnsupportedOperationException("Use IgniteRepository.save(Map<keys,value>) method instead.");
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.cache.get(id));
    }

    public boolean existsById(ID id) {
        return this.cache.containsKey(id);
    }

    public Iterable<T> findAll() {
        final Iterator iter = this.cache.iterator();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((Cache.Entry)iter.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        if (ids instanceof Set) {
            return this.cache.getAll((Set)ids).values();
        }
        if (ids instanceof Collection) {
            return this.cache.getAll(new HashSet((Collection)ids)).values();
        }
        TreeSet<Serializable> keys = new TreeSet<Serializable>();
        for (Serializable id : ids) {
            keys.add(id);
        }
        return this.cache.getAll(keys).values();
    }

    public long count() {
        return this.cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY});
    }

    public void deleteById(ID id) {
        this.cache.remove(id);
    }

    public void delete(T entity) {
        throw new UnsupportedOperationException("Use IgniteRepository.deleteById(key) method instead.");
    }

    public void deleteAll(Iterable<? extends T> entities) {
        throw new UnsupportedOperationException("Use IgniteRepository.deleteAllById(keys) method instead.");
    }

    @Override
    public void deleteAllById(Iterable<ID> ids) {
        if (ids instanceof Set) {
            this.cache.removeAll((Set)ids);
        }
        if (ids instanceof Collection) {
            this.cache.removeAll(new HashSet((Collection)ids));
        }
        TreeSet<Serializable> keys = new TreeSet<Serializable>();
        for (Serializable id : ids) {
            keys.add(id);
        }
        this.cache.removeAll(keys);
    }

    public void deleteAll() {
        this.cache.clear();
    }
}

