/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSessionImplwithUGI
extends HiveSessionImpl {
    public static final String HS2TOKEN = "HiveServer2ImpersonationToken";
    static final Logger LOG = LoggerFactory.getLogger(HiveSessionImplwithUGI.class);
    private UserGroupInformation sessionUgi = null;
    private String hmsDelegationTokenStr = null;
    private HiveSession proxySession = null;

    public HiveSessionImplwithUGI(TProtocolVersion protocol, String username, String password, HiveConf hiveConf, String ipAddress, String delegationToken) throws HiveSQLException {
        super(protocol, username, password, hiveConf, ipAddress);
        this.setSessionUGI(username);
        this.setDelegationToken(delegationToken);
    }

    public void setSessionUGI(String owner) throws HiveSQLException {
        if (owner == null) {
            throw new HiveSQLException("No username provided for impersonation");
        }
        try {
            this.sessionUgi = UserGroupInformation.createProxyUser((String)owner, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            throw new HiveSQLException("Couldn't setup proxy user", e);
        }
    }

    public UserGroupInformation getSessionUgi() {
        return this.sessionUgi;
    }

    public String getDelegationToken() {
        return this.hmsDelegationTokenStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire(true);
            this.cancelDelegationToken();
        }
        finally {
            try {
                super.close();
            }
            finally {
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)this.sessionUgi);
                }
                catch (IOException ioe) {
                    throw new HiveSQLException("Could not clean up file-system handles for UGI: " + this.sessionUgi, ioe);
                }
            }
        }
    }

    private void setDelegationToken(String hmsDelegationTokenStr) throws HiveSQLException {
        this.hmsDelegationTokenStr = hmsDelegationTokenStr;
        if (hmsDelegationTokenStr != null) {
            this.getHiveConf().set("hive.metastore.token.signature", HS2TOKEN);
            try {
                Utils.setTokenStr((UserGroupInformation)this.sessionUgi, (String)hmsDelegationTokenStr, (String)HS2TOKEN);
            }
            catch (IOException e) {
                throw new HiveSQLException("Couldn't setup delegation token in the ugi: " + e, e);
            }
        }
    }

    private void cancelDelegationToken() throws HiveSQLException {
        if (this.hmsDelegationTokenStr != null) {
            try {
                Hive.get((HiveConf)this.getHiveConf()).cancelDelegationToken(this.hmsDelegationTokenStr);
            }
            catch (HiveException e) {
                throw new HiveSQLException("Couldn't cancel delegation token", e);
            }
        }
    }

    @Override
    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        return this.getMetaStoreClient(true);
    }

    private IMetaStoreClient getMetaStoreClient(boolean retryInCaseOfTokenExpiration) throws HiveSQLException {
        try {
            return Hive.get((HiveConf)this.getHiveConf()).getMSC();
        }
        catch (HiveException e) {
            throw new HiveSQLException("Failed to get metastore connection: " + (Object)((Object)e), e);
        }
        catch (MetaException e1) {
            if (this.hmsDelegationTokenStr != null && retryInCaseOfTokenExpiration) {
                LOG.info("Retrying failed metastore connection: " + (Object)((Object)e1), (Throwable)e1);
                Hive.closeCurrent();
                try {
                    this.setDelegationToken(Hive.get((HiveConf)this.getHiveConf()).getDelegationToken(this.sessionUgi.getUserName(), this.getUserName()));
                }
                catch (HiveException e2) {
                    throw new HiveSQLException("Error connect metastore to setup impersonation: " + (Object)((Object)e2), e2);
                }
                return this.getMetaStoreClient(false);
            }
            throw new HiveSQLException("Failed to get metastore connection: " + (Object)((Object)e1), e1);
        }
    }

    @Override
    protected HiveSession getSession() {
        assert (this.proxySession != null);
        return this.proxySession;
    }

    public void setProxySession(HiveSession proxySession) {
        this.proxySession = proxySession;
    }

    @Override
    public String getDelegationToken(HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        return authFactory.getDelegationToken(owner, renewer);
    }

    @Override
    public void cancelDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        authFactory.cancelDelegationToken(tokenStr);
    }

    @Override
    public void renewDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        authFactory.renewDelegationToken(tokenStr);
    }
}

