/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.parquet.Preconditions;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public abstract class ConversionPatterns {
    private static final String ELEMENT_NAME = "element";

    private static GroupType listWrapper(Type.Repetition repetition, String alias, OriginalType originalType, Type nested) {
        if (!nested.isRepetition(Type.Repetition.REPEATED)) {
            throw new IllegalArgumentException("Nested type should be repeated: " + nested);
        }
        return new GroupType(repetition, alias, originalType, nested);
    }

    public static GroupType mapType(Type.Repetition repetition, String alias, Type keyType, Type valueType) {
        return ConversionPatterns.mapType(repetition, alias, "map", keyType, valueType);
    }

    public static GroupType stringKeyMapType(Type.Repetition repetition, String alias, String mapAlias, Type valueType) {
        return ConversionPatterns.mapType(repetition, alias, mapAlias, new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key", OriginalType.UTF8), valueType);
    }

    public static GroupType stringKeyMapType(Type.Repetition repetition, String alias, Type valueType) {
        return ConversionPatterns.stringKeyMapType(repetition, alias, "map", valueType);
    }

    public static GroupType mapType(Type.Repetition repetition, String alias, String mapAlias, Type keyType, Type valueType) {
        if (valueType == null) {
            return ConversionPatterns.listWrapper(repetition, alias, OriginalType.MAP, new GroupType(Type.Repetition.REPEATED, mapAlias, OriginalType.MAP_KEY_VALUE, keyType));
        }
        if (!valueType.getName().equals("value")) {
            throw new RuntimeException(valueType.getName() + " should be value");
        }
        return ConversionPatterns.listWrapper(repetition, alias, OriginalType.MAP, new GroupType(Type.Repetition.REPEATED, mapAlias, OriginalType.MAP_KEY_VALUE, keyType, valueType));
    }

    @Deprecated
    public static GroupType listType(Type.Repetition repetition, String alias, Type nestedType) {
        return ConversionPatterns.listWrapper(repetition, alias, OriginalType.LIST, nestedType);
    }

    public static GroupType listOfElements(Type.Repetition listRepetition, String name, Type elementType) {
        Preconditions.checkArgument(elementType.getName().equals(ELEMENT_NAME), "List element type must be named 'element'");
        return ConversionPatterns.listWrapper(listRepetition, name, OriginalType.LIST, new GroupType(Type.Repetition.REPEATED, "list", elementType));
    }
}

