/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;

public class UnwrapRowContainer
implements MapJoinRowContainer,
AbstractRowContainer.RowIterator<List<Object>> {
    private final byte alias;
    private final int[] valueIndex;
    private final ObjectInspectorConverters.Converter[] converters;
    private final boolean tagged;
    private final List<Object> unwrapped;
    private transient Object[] currentKey;
    private transient MapJoinRowContainer internal;
    private transient AbstractRowContainer.RowIterator<List<Object>> iterator;

    public UnwrapRowContainer(byte alias, int[] valueIndex, ObjectInspectorConverters.Converter[] converters, boolean tagged) {
        this.alias = alias;
        this.valueIndex = valueIndex;
        this.converters = converters;
        this.tagged = tagged;
        this.unwrapped = new ArrayList<Object>();
    }

    public MapJoinRowContainer setInternal(MapJoinRowContainer internal, Object[] currentKey) {
        this.internal = internal;
        this.currentKey = currentKey;
        return this;
    }

    @Override
    public List<Object> first() throws HiveException {
        this.iterator = this.internal.rowIter();
        return this.unwrap(this.iterator.first());
    }

    @Override
    public List<Object> next() throws HiveException {
        return this.unwrap(this.iterator.next());
    }

    private List<Object> unwrap(List<Object> values) {
        if (values == null) {
            return null;
        }
        this.unwrapped.clear();
        for (int pos = 0; pos < this.valueIndex.length; ++pos) {
            int index = this.valueIndex[pos];
            if (index >= 0) {
                if (this.currentKey == null) {
                    this.unwrapped.add(null);
                    continue;
                }
                if (this.converters[pos] != null) {
                    this.unwrapped.add(this.converters[pos].convert(this.currentKey[index]));
                    continue;
                }
                this.unwrapped.add(this.currentKey[index]);
                continue;
            }
            this.unwrapped.add(values.get(-index - 1));
        }
        if (this.tagged) {
            this.unwrapped.add(values.get(values.size() - 1));
        }
        return this.unwrapped;
    }

    @Override
    public AbstractRowContainer.RowIterator<List<Object>> rowIter() throws HiveException {
        return this;
    }

    @Override
    public void addRow(List<Object> t) throws HiveException {
        this.internal.addRow(t);
    }

    @Override
    public boolean hasRows() throws HiveException {
        return this.internal.hasRows();
    }

    @Override
    public boolean isSingleRow() throws HiveException {
        return this.internal.isSingleRow();
    }

    @Override
    public int rowCount() throws HiveException {
        return this.internal.rowCount();
    }

    @Override
    public void clearRows() throws HiveException {
        this.internal.clearRows();
    }

    @Override
    public byte getAliasFilter() throws HiveException {
        return this.internal.getAliasFilter();
    }

    @Override
    public MapJoinRowContainer copy() throws HiveException {
        this.internal = this.internal.copy();
        return this;
    }

    @Override
    public void addRow(Object[] value) throws HiveException {
        this.internal.addRow(value);
    }

    @Override
    public void write(MapJoinObjectSerDeContext valueContext, ObjectOutputStream out) throws IOException, SerDeException {
        this.internal.write(valueContext, out);
    }

    public String toString() {
        return this.alias + (this.tagged ? ":TAGGED" : "") + Arrays.toString(this.valueIndex);
    }
}

