/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.DelegatedObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class DelegatedMapObjectInspector
implements MapObjectInspector {
    private MapObjectInspector delegate;
    private ObjectInspector key;
    private ObjectInspector value;

    public DelegatedMapObjectInspector(MapObjectInspector delegate) {
        this.delegate = delegate;
    }

    public void reset(MapObjectInspector current) {
        this.delegate = current;
        if (this.key != null) {
            DelegatedObjectInspectorFactory.reset(this.key, current.getMapKeyObjectInspector());
        }
        if (this.value != null) {
            DelegatedObjectInspectorFactory.reset(this.value, current.getMapValueObjectInspector());
        }
    }

    @Override
    public ObjectInspector getMapKeyObjectInspector() {
        return this.key != null ? this.key : (this.key = DelegatedObjectInspectorFactory.wrap(this.delegate.getMapKeyObjectInspector()));
    }

    @Override
    public ObjectInspector getMapValueObjectInspector() {
        return this.value != null ? this.value : (this.value = DelegatedObjectInspectorFactory.wrap(this.delegate.getMapValueObjectInspector()));
    }

    @Override
    public Object getMapValueElement(Object data, Object key) {
        return this.delegate.getMapValueElement(data, key);
    }

    @Override
    public Map<?, ?> getMap(Object data) {
        return this.delegate.getMap(data);
    }

    @Override
    public int getMapSize(Object data) {
        return this.delegate.getMapSize(data);
    }

    @Override
    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return this.delegate.getCategory();
    }
}

