/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.SerDeStatsStruct;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryNonPrimitive;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryObject;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class LazyBinaryStruct
extends LazyBinaryNonPrimitive<LazyBinaryStructObjectInspector>
implements SerDeStatsStruct {
    private static Log LOG = LogFactory.getLog((String)LazyBinaryStruct.class.getName());
    boolean parsed;
    long serializedSize;
    LazyBinaryObject[] fields;
    boolean[] fieldInited;
    boolean[] fieldIsNull;
    int[] fieldStart;
    int[] fieldLength;
    LazyBinaryUtils.RecordInfo recordInfo = new LazyBinaryUtils.RecordInfo();
    boolean missingFieldWarned = false;
    boolean extraFieldWarned = false;
    ArrayList<Object> cachedList;

    protected LazyBinaryStruct(LazyBinaryStructObjectInspector oi) {
        super(oi);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        super.init(bytes, start, length);
        this.parsed = false;
        this.serializedSize = length;
    }

    private void parse() {
        List<? extends StructField> fieldRefs = ((StructObjectInspector)this.oi).getAllStructFieldRefs();
        if (this.fields == null) {
            this.fields = new LazyBinaryObject[fieldRefs.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                ObjectInspector insp = fieldRefs.get(i).getFieldObjectInspector();
                this.fields[i] = insp == null ? null : LazyBinaryFactory.createLazyBinaryObject(insp);
            }
            this.fieldInited = new boolean[this.fields.length];
            this.fieldIsNull = new boolean[this.fields.length];
            this.fieldStart = new int[this.fields.length];
            this.fieldLength = new int[this.fields.length];
        }
        int fieldId = 0;
        int structByteEnd = this.start + this.length;
        byte[] bytes = this.bytes.getData();
        byte nullByte = bytes[this.start];
        int lastFieldByteEnd = this.start + 1;
        for (int i = 0; i < this.fields.length; ++i) {
            this.fieldIsNull[i] = true;
            if ((nullByte & 1 << i % 8) != 0) {
                this.fieldIsNull[i] = false;
                LazyBinaryUtils.checkObjectByteInfo(fieldRefs.get(i).getFieldObjectInspector(), bytes, lastFieldByteEnd, this.recordInfo);
                this.fieldStart[i] = lastFieldByteEnd + this.recordInfo.elementOffset;
                this.fieldLength[i] = this.recordInfo.elementSize;
                lastFieldByteEnd = this.fieldStart[i] + this.fieldLength[i];
            }
            if (lastFieldByteEnd <= structByteEnd) {
                ++fieldId;
            }
            if (7 != i % 8) continue;
            if (lastFieldByteEnd < structByteEnd) {
                nullByte = bytes[lastFieldByteEnd];
                ++lastFieldByteEnd;
                continue;
            }
            nullByte = 0;
            ++lastFieldByteEnd;
        }
        if (!this.extraFieldWarned && lastFieldByteEnd < structByteEnd) {
            this.extraFieldWarned = true;
            LOG.warn((Object)"Extra bytes detected at the end of the row! Ignoring similar problems.");
        }
        if (!this.missingFieldWarned && lastFieldByteEnd > structByteEnd) {
            this.missingFieldWarned = true;
            LOG.info((Object)("Missing fields! Expected " + this.fields.length + " fields but " + "only got " + fieldId + "! Ignoring similar problems."));
        }
        Arrays.fill(this.fieldInited, false);
        this.parsed = true;
    }

    public Object getField(int fieldID) {
        if (!this.parsed) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        if (this.fieldIsNull[fieldID]) {
            return null;
        }
        if (!this.fieldInited[fieldID]) {
            this.fieldInited[fieldID] = true;
            this.fields[fieldID].init(this.bytes, this.fieldStart[fieldID], this.fieldLength[fieldID]);
        }
        return this.fields[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.parsed) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public long getRawDataSerializedSize() {
        return this.serializedSize;
    }
}

