/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.columnar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDeBase;
import org.apache.hadoop.hive.serde2.columnar.ColumnarStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;

public class ColumnarSerDe
extends ColumnarSerDeBase {
    public static final Log LOG = LogFactory.getLog((String)ColumnarSerDe.class.getName());
    LazySimpleSerDe.SerDeParameters serdeParams = null;

    public String toString() {
        return this.getClass().toString() + "[" + Arrays.asList(new byte[][]{this.serdeParams.getSeparators()}) + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames() + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos() + "]";
    }

    @Override
    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        this.serdeParams = LazySimpleSerDe.initSerdeParams(job, tbl, this.getClass().getName());
        this.cachedObjectInspector = LazyFactory.createColumnarStructInspector(this.serdeParams.getColumnNames(), this.serdeParams.getColumnTypes(), this.serdeParams.getSeparators(), this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar());
        ArrayList<Integer> notSkipIDs = ColumnProjectionUtils.getReadColumnIDs(job);
        this.cachedLazyStruct = new ColumnarStruct(this.cachedObjectInspector, notSkipIDs, this.serdeParams.getNullSequence());
        int size = this.serdeParams.getColumnTypes().size();
        super.initialize(size);
        LOG.debug((Object)("ColumnarSerDe initialized with: columnNames=" + this.serdeParams.getColumnNames() + " columnTypes=" + this.serdeParams.getColumnTypes() + " separator=" + Arrays.asList(new byte[][]{this.serdeParams.getSeparators()}) + " nullstring=" + this.serdeParams.getNullString()));
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(obj);
        List<? extends StructField> declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        try {
            this.serializeStream.reset();
            this.serializedSize = 0L;
            int count = 0;
            for (int i = 0; i < fields.size(); ++i) {
                Object f;
                ObjectInspector foi = fields.get(i).getFieldObjectInspector();
                Object object = f = list == null ? null : list.get(i);
                if (declaredFields != null && i >= declaredFields.size()) {
                    throw new SerDeException("Error: expecting " + declaredFields.size() + " but asking for field " + i + "\n" + "data=" + obj + "\n" + "tableType=" + this.serdeParams.getRowTypeInfo().toString() + "\n" + "dataType=" + TypeInfoUtils.getTypeInfoFromObjectInspector(objInspector));
                }
                if (!foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && (declaredFields == null || declaredFields.get(i).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE))) {
                    LazySimpleSerDe.serialize(this.serializeStream, SerDeUtils.getJSONString(f, foi), PrimitiveObjectInspectorFactory.javaStringObjectInspector, this.serdeParams.getSeparators(), 1, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
                } else {
                    LazySimpleSerDe.serialize(this.serializeStream, f, foi, this.serdeParams.getSeparators(), 1, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
                }
                this.field[i].set(this.serializeStream.getData(), count, this.serializeStream.getCount() - count);
                count = this.serializeStream.getCount();
            }
            this.serializedSize = this.serializeStream.getCount();
            this.lastOperationSerialize = true;
            this.lastOperationDeserialize = false;
        }
        catch (IOException e) {
            throw new SerDeException(e);
        }
        return this.serializeCache;
    }
}

