/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="datediff", value="_FUNC_(date1, date2) - Returns the number of days between date1 and date2", extended="date1 and date2 are strings in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time parts are ignored.If date1 is earlier than date2, the result is negative.\nExample:\n   > SELECT _FUNC_('2009-30-07', '2009-31-07') FROM src LIMIT 1;\n  1")
public class UDFDateDiff
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final IntWritable result = new IntWritable();

    public UDFDateDiff() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public IntWritable evaluate(Text dateString1, Text dateString2) {
        return this.evaluate(this.toDate(dateString1), this.toDate(dateString2));
    }

    public IntWritable evaluate(TimestampWritable t1, TimestampWritable t2) {
        return this.evaluate(this.toDate(t1), this.toDate(t2));
    }

    public IntWritable evaluate(TimestampWritable t, Text dateString) {
        return this.evaluate(this.toDate(t), this.toDate(dateString));
    }

    public IntWritable evaluate(Text dateString, TimestampWritable t) {
        return this.evaluate(this.toDate(dateString), this.toDate(t));
    }

    public IntWritable evaluate(Text dateString, DateWritable d) {
        return this.evaluate(this.toDate(dateString), d.get());
    }

    public IntWritable evaluate(TimestampWritable t, DateWritable d) {
        return this.evaluate(this.toDate(t), d.get());
    }

    public IntWritable evaluate(DateWritable d1, DateWritable d2) {
        return this.evaluate(d1.get(), d2.get());
    }

    public IntWritable evaluate(DateWritable d, Text dateString) {
        return this.evaluate(d.get(), this.toDate(dateString));
    }

    public IntWritable evaluate(DateWritable d, TimestampWritable t) {
        return this.evaluate(d.get(), this.toDate(t));
    }

    private IntWritable evaluate(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        long diffInMilliSeconds = date.getTime() - date2.getTime();
        this.result.set((int)(diffInMilliSeconds / 86400000L));
        return this.result;
    }

    private Date format(String dateString) {
        try {
            return this.formatter.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Date toDate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        return this.format(dateString.toString());
    }

    private Date toDate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        return t.getTimestamp();
    }
}

