/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class AddResourceProcessor
implements CommandProcessor {
    public static final Log LOG = LogFactory.getLog((String)AddResourceProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState.ResourceType t;
        SessionState ss = SessionState.get();
        command = new VariableSubstitution().substitute(ss.getConf(), command);
        String[] tokens = command.split("\\s+");
        if (tokens.length < 2 || (t = SessionState.find_resource_type(tokens[0])) == null) {
            console.printError("Usage: add [" + StringUtils.join((Object[])SessionState.ResourceType.values(), "|") + "] <value> [<value>]*");
            return new CommandProcessorResponse(1);
        }
        for (int i = 1; i < tokens.length; ++i) {
            String resourceFile = ss.add_resource(t, tokens[i]);
            if (resourceFile != null) continue;
            String errMsg = tokens[i] + " does not exist.";
            return new CommandProcessorResponse(1, errMsg, null);
        }
        return new CommandProcessorResponse(0);
    }
}

