/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 631: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 675: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 633: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 657: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 562: 
            case 564: 
            case 565: 
            case 569: 
            case 570: 
            case 571: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 580: 
            case 582: 
            case 583: 
            case 584: 
            case 593: 
            case 595: 
            case 598: 
            case 612: 
            case 613: 
            case 614: 
            case 620: 
            case 622: 
            case 624: 
            case 625: 
            case 626: 
            case 627: 
            case 628: 
            case 630: 
            case 642: 
            case 643: 
            case 677: 
            case 680: 
            case 732: 
            case 733: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 751: 
            case 752: 
            case 753: 
            case 754: 
            case 755: 
            case 768: 
            case 811: 
            case 815: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 568: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 594: 
            case 621: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 585: {
                return new ColumnStatsSemanticAnalyzer(conf, tree);
            }
            case 597: 
            case 623: {
                return new MacroSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(631, HiveOperation.EXPLAIN);
        commandType.put(675, HiveOperation.LOAD);
        commandType.put(633, HiveOperation.EXPORT);
        commandType.put(657, HiveOperation.IMPORT);
        commandType.put(593, HiveOperation.CREATEDATABASE);
        commandType.put(620, HiveOperation.DROPDATABASE);
        commandType.put(768, HiveOperation.SWITCHDATABASE);
        commandType.put(599, HiveOperation.CREATETABLE);
        commandType.put(811, HiveOperation.TRUNCATETABLE);
        commandType.put(625, HiveOperation.DROPTABLE);
        commandType.put(614, HiveOperation.DESCTABLE);
        commandType.put(613, HiveOperation.DESCFUNCTION);
        commandType.put(680, HiveOperation.MSCK);
        commandType.put(557, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(573, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(571, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(570, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(565, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(558, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(577, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(562, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(578, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(569, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(626, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(745, HiveOperation.SHOWDATABASES);
        commandType.put(750, HiveOperation.SHOWTABLES);
        commandType.put(744, HiveOperation.SHOWCOLUMNS);
        commandType.put(754, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(755, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(751, HiveOperation.SHOW_CREATETABLE);
        commandType.put(746, HiveOperation.SHOWFUNCTIONS);
        commandType.put(747, HiveOperation.SHOWINDEXES);
        commandType.put(749, HiveOperation.SHOWPARTITIONS);
        commandType.put(748, HiveOperation.SHOWLOCKS);
        commandType.put(594, HiveOperation.CREATEFUNCTION);
        commandType.put(621, HiveOperation.DROPFUNCTION);
        commandType.put(597, HiveOperation.CREATEMACRO);
        commandType.put(623, HiveOperation.DROPMACRO);
        commandType.put(600, HiveOperation.CREATEVIEW);
        commandType.put(627, HiveOperation.DROPVIEW);
        commandType.put(595, HiveOperation.CREATEINDEX);
        commandType.put(622, HiveOperation.DROPINDEX);
        commandType.put(556, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(555, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(583, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(628, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(580, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(582, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(727, HiveOperation.QUERY);
        commandType.put(677, HiveOperation.LOCKTABLE);
        commandType.put(815, HiveOperation.UNLOCKTABLE);
        commandType.put(598, HiveOperation.CREATEROLE);
        commandType.put(624, HiveOperation.DROPROLE);
        commandType.put(642, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(732, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(752, HiveOperation.SHOW_GRANT);
        commandType.put(643, HiveOperation.GRANT_ROLE);
        commandType.put(733, HiveOperation.REVOKE_ROLE);
        commandType.put(753, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(554, HiveOperation.ALTERDATABASE);
        commandType.put(612, HiveOperation.DESCDATABASE);
        commandType.put(576, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(585, HiveOperation.ANALYZE_TABLE);
        commandType.put(584, HiveOperation.ALTERVIEW_RENAME);
        tablePartitionCommandType.put(561, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(566, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(567, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(560, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(575, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(574, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(572, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(579, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(777, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(564, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
    }
}

