/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;

public class ColumnPrunerProcCtx
implements NodeProcessorCtx {
    private final Map<Operator<? extends OperatorDesc>, List<String>> prunedColLists = new HashMap<Operator<? extends OperatorDesc>, List<String>>();
    private final HashMap<Operator<? extends OperatorDesc>, OpParseContext> opToParseCtxMap;
    private final Map<CommonJoinOperator, Map<Byte, List<String>>> joinPrunedColLists;

    public ColumnPrunerProcCtx(HashMap<Operator<? extends OperatorDesc>, OpParseContext> opToParseContextMap) {
        this.opToParseCtxMap = opToParseContextMap;
        this.joinPrunedColLists = new HashMap<CommonJoinOperator, Map<Byte, List<String>>>();
    }

    public Map<CommonJoinOperator, Map<Byte, List<String>>> getJoinPrunedColLists() {
        return this.joinPrunedColLists;
    }

    public List<String> getPrunedColList(Operator<? extends OperatorDesc> op) {
        return this.prunedColLists.get(op);
    }

    public HashMap<Operator<? extends OperatorDesc>, OpParseContext> getOpToParseCtxMap() {
        return this.opToParseCtxMap;
    }

    public Map<Operator<? extends OperatorDesc>, List<String>> getPrunedColLists() {
        return this.prunedColLists;
    }

    public List<String> genColLists(Operator<? extends OperatorDesc> curOp) throws SemanticException {
        List<String> colList = new ArrayList<String>();
        if (curOp.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : curOp.getChildOperators()) {
                if (child instanceof CommonJoinOperator) {
                    int tag = child.getParentOperators().indexOf(curOp);
                    List<String> prunList = this.joinPrunedColLists.get(child).get((byte)tag);
                    colList = Utilities.mergeUniqElems(colList, prunList);
                    continue;
                }
                colList = Utilities.mergeUniqElems(colList, this.prunedColLists.get(child));
            }
        }
        return colList;
    }

    public List<String> getColsFromSelectExpr(SelectOperator op) {
        List<String> cols = new ArrayList<String>();
        SelectDesc conf = (SelectDesc)op.getConf();
        List<ExprNodeDesc> exprList = conf.getColList();
        for (ExprNodeDesc expr : exprList) {
            cols = Utilities.mergeUniqElems(cols, expr.getCols());
        }
        return cols;
    }

    public List<String> getSelectColsFromChildren(SelectOperator op, List<String> colList) {
        List<String> cols = new ArrayList<String>();
        SelectDesc conf = (SelectDesc)op.getConf();
        if (conf.isSelStarNoCompute()) {
            cols.addAll(colList);
            return cols;
        }
        List<ExprNodeDesc> selectExprs = conf.getColList();
        List<String> outputColumnNames = conf.getOutputColumnNames();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            if (!colList.contains(outputColumnNames.get(i))) continue;
            ExprNodeDesc expr = selectExprs.get(i);
            cols = Utilities.mergeUniqElems(cols, expr.getCols());
        }
        return cols;
    }

    public List<String> getSelectColsFromLVJoin(RowResolver rr, List<String> colList) throws SemanticException {
        ArrayList<String> columns = new ArrayList<String>();
        for (String col : colList) {
            if (rr.reverseLookup(col) == null) continue;
            columns.add(col);
        }
        return columns;
    }
}

