/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public final class OrcFile {
    public static final String MAGIC = "ORC";
    public static final String COMPRESSION = "orc.compress";
    public static final String COMPRESSION_BLOCK_SIZE = "orc.compress.size";
    public static final String STRIPE_SIZE = "orc.stripe.size";
    public static final String ROW_INDEX_STRIDE = "orc.row.index.stride";
    public static final String ENABLE_INDEXES = "orc.create.index";
    public static final String BLOCK_PADDING = "orc.block.padding";
    static final long DEFAULT_STRIPE_SIZE = 0x10000000L;
    static final CompressionKind DEFAULT_COMPRESSION_KIND = CompressionKind.ZLIB;
    static final int DEFAULT_BUFFER_SIZE = 262144;
    static final int DEFAULT_ROW_INDEX_STRIDE = 10000;
    static final boolean DEFAULT_BLOCK_PADDING = true;
    private static MemoryManager memoryManager = null;

    private OrcFile() {
    }

    public static Reader createReader(FileSystem fs, Path path) throws IOException {
        return new ReaderImpl(fs, path);
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(conf);
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.fileSystemValue == null ? path.getFileSystem(opts.configuration) : opts.fileSystemValue;
        return new WriterImpl(fs, path, opts.configuration, opts.inspectorValue, opts.stripeSizeValue, opts.compressValue, opts.bufferSizeValue, opts.rowIndexStrideValue, opts.memoryManagerValue, opts.blockPaddingValue, opts.versionValue);
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride) throws IOException {
        return OrcFile.createWriter(path, OrcFile.writerOptions(conf).fileSystem(fs).inspector(inspector).stripeSize(stripeSize).compress(compress).bufferSize(bufferSize).rowIndexStride(rowIndexStride));
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManager(conf);
        }
        return memoryManager;
    }

    public static class WriterOptions {
        private final Configuration configuration;
        private FileSystem fileSystemValue = null;
        private ObjectInspector inspectorValue = null;
        private long stripeSizeValue = 0x10000000L;
        private int rowIndexStrideValue = 10000;
        private int bufferSizeValue = 262144;
        private boolean blockPaddingValue = true;
        private CompressionKind compressValue = DEFAULT_COMPRESSION_KIND;
        private MemoryManager memoryManagerValue;
        private Version versionValue;

        WriterOptions(Configuration conf) {
            this.configuration = conf;
            this.memoryManagerValue = OrcFile.getMemoryManager(conf);
            String versionName = conf.get(HiveConf.ConfVars.HIVE_ORC_WRITE_FORMAT.varname);
            this.versionValue = versionName == null ? Version.CURRENT : Version.byName(versionName);
        }

        public WriterOptions fileSystem(FileSystem value) {
            this.fileSystemValue = value;
            return this;
        }

        public WriterOptions stripeSize(long value) {
            this.stripeSizeValue = value;
            return this;
        }

        public WriterOptions rowIndexStride(int value) {
            this.rowIndexStrideValue = value;
            return this;
        }

        public WriterOptions bufferSize(int value) {
            this.bufferSizeValue = value;
            return this;
        }

        public WriterOptions blockPadding(boolean value) {
            this.blockPaddingValue = value;
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            this.compressValue = value;
            return this;
        }

        public WriterOptions inspector(ObjectInspector value) {
            this.inspectorValue = value;
            return this;
        }

        public WriterOptions version(Version value) {
            this.versionValue = value;
            return this;
        }

        WriterOptions memory(MemoryManager value) {
            this.memoryManagerValue = value;
            return this;
        }
    }

    public static enum Version {
        V_0_11("0.11", 0, 11),
        V_0_12("0.12", 0, 12);

        public static final Version CURRENT;
        private final String name;
        private final int major;
        private final int minor;

        private Version(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public static Version byName(String name) {
            for (Version version : Version.values()) {
                if (!version.name.equals(name)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown ORC version " + name);
        }

        public String getName() {
            return this.name;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        static {
            CURRENT = V_0_12;
        }
    }
}

