/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.AbstractIndexHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public abstract class TableBasedIndexHandler
extends AbstractIndexHandler {
    protected Configuration configuration;

    @Override
    public List<Task<?>> generateIndexBuildTaskList(Table baseTbl, Index index, List<Partition> indexTblPartitions, List<Partition> baseTblPartitions, Table indexTbl, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws HiveException {
        try {
            TableDesc desc = Utilities.getTableDesc(indexTbl);
            ArrayList<Partition> newBaseTblPartitions = new ArrayList<Partition>();
            ArrayList indexBuilderTasks = new ArrayList();
            if (!baseTbl.isPartitioned()) {
                Task<?> indexBuilder = this.getIndexBuilderMapRedTask(inputs, outputs, index.getSd().getCols(), false, new PartitionDesc(desc, null), indexTbl.getTableName(), new PartitionDesc(Utilities.getTableDesc(baseTbl), null), baseTbl.getTableName(), indexTbl.getDbName());
                indexBuilderTasks.add(indexBuilder);
            } else {
                for (int i = 0; i < indexTblPartitions.size(); ++i) {
                    Partition indexPart = indexTblPartitions.get(i);
                    Partition basePart = null;
                    for (int j = 0; j < baseTblPartitions.size(); ++j) {
                        if (!baseTblPartitions.get(j).getName().equals(indexPart.getName())) continue;
                        basePart = baseTblPartitions.get(j);
                        newBaseTblPartitions.add(baseTblPartitions.get(j));
                        break;
                    }
                    if (basePart == null) {
                        throw new RuntimeException("Partitions of base table and index table are inconsistent.");
                    }
                    Task<?> indexBuilder = this.getIndexBuilderMapRedTask(inputs, outputs, index.getSd().getCols(), true, new PartitionDesc(indexPart), indexTbl.getTableName(), new PartitionDesc(basePart), baseTbl.getTableName(), indexTbl.getDbName());
                    indexBuilderTasks.add(indexBuilder);
                }
            }
            return indexBuilderTasks;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    protected abstract Task<?> getIndexBuilderMapRedTask(Set<ReadEntity> var1, Set<WriteEntity> var2, List<FieldSchema> var3, boolean var4, PartitionDesc var5, String var6, PartitionDesc var7, String var8, String var9) throws HiveException;

    protected List<String> getPartKVPairStringArray(LinkedHashMap<String, String> partSpec) {
        ArrayList<String> ret = new ArrayList<String>(partSpec.size());
        Iterator<Map.Entry<String, String>> iter = partSpec.entrySet().iterator();
        while (iter.hasNext()) {
            StringBuilder sb = new StringBuilder();
            Map.Entry<String, String> p = iter.next();
            sb.append(HiveUtils.unparseIdentifier(p.getKey()));
            sb.append(" = ");
            sb.append("'");
            sb.append(HiveUtils.escapeString(p.getValue()));
            sb.append("'");
            ret.add(sb.toString());
        }
        return ret;
    }

    @Override
    public boolean usesIndexTable() {
        return true;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
    }
}

