/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;

public class HashMapWrapper
extends AbstractMapJoinTableContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog(HashMapWrapper.class);
    private static final String THESHOLD_NAME = "threshold";
    private static final String LOAD_NAME = "load";
    private static final int THRESHOLD = 1000000;
    private static final float LOADFACTOR = 0.75f;
    private HashMap<MapJoinKey, MapJoinRowContainer> mHash;

    public HashMapWrapper(int threshold, float loadFactor) {
        super(HashMapWrapper.createConstructorMetaData(threshold, loadFactor));
        this.mHash = new HashMap(threshold, loadFactor);
    }

    public HashMapWrapper(Map<String, String> metaData) {
        super(metaData);
        int threshold = Integer.parseInt(metaData.get(THESHOLD_NAME));
        float loadFactor = Float.parseFloat(metaData.get(LOAD_NAME));
        this.mHash = new HashMap(threshold, loadFactor);
    }

    public HashMapWrapper(int threshold) {
        this(threshold, 0.75f);
    }

    public HashMapWrapper() {
        this(1000000, 0.75f);
    }

    @Override
    public MapJoinRowContainer get(MapJoinKey key) {
        return this.mHash.get(key);
    }

    @Override
    public void put(MapJoinKey key, MapJoinRowContainer value) {
        this.mHash.put(key, value);
    }

    @Override
    public int size() {
        return this.mHash.size();
    }

    @Override
    public Set<Map.Entry<MapJoinKey, MapJoinRowContainer>> entrySet() {
        return this.mHash.entrySet();
    }

    @Override
    public void clear() {
        this.mHash.clear();
    }

    private static Map<String, String> createConstructorMetaData(int threshold, float loadFactor) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(THESHOLD_NAME, String.valueOf(threshold));
        metaData.put(LOAD_NAME, String.valueOf(loadFactor));
        return metaData;
    }
}

