/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;

public class ExecMapper
extends MapReduceBase
implements Mapper {
    private MapOperator mo;
    private Map<String, FetchOperator> fetchOperators;
    private OutputCollector oc;
    private JobConf jc;
    private boolean abort = false;
    private Reporter rp;
    public static final Log l4j = LogFactory.getLog(ExecMapper.class);
    private static boolean done;
    public static MemoryMXBean memoryMXBean;
    private long numRows = 0L;
    private long nextCntr = 1L;
    private MapredLocalWork localWork = null;
    private boolean isLogInfoEnabled = false;
    private final ExecMapperContext execContext = new ExecMapperContext();

    public void configure(JobConf job) {
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        l4j.info((Object)("maximum memory = " + memoryMXBean.getHeapMemoryUsage().getMax()));
        this.isLogInfoEnabled = l4j.isInfoEnabled();
        try {
            l4j.info((Object)("conf classpath = " + Arrays.asList(((URLClassLoader)job.getClassLoader()).getURLs())));
            l4j.info((Object)("thread classpath = " + Arrays.asList(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs())));
        }
        catch (Exception e) {
            l4j.info((Object)("cannot get classpath: " + e.getMessage()));
        }
        try {
            this.jc = job;
            this.execContext.setJc(this.jc);
            MapWork mrwork = Utilities.getMapWork((Configuration)job);
            this.mo = new MapOperator();
            this.mo.setConf(mrwork);
            this.mo.setChildren((Configuration)job);
            l4j.info((Object)this.mo.dump(0));
            this.localWork = mrwork.getMapLocalWork();
            this.execContext.setLocalWork(this.localWork);
            MapredContext.init(true, new JobConf((Configuration)this.jc));
            this.mo.setExecContext(this.execContext);
            this.mo.initializeLocalWork((Configuration)this.jc);
            this.mo.initialize((Configuration)this.jc, null);
            if (this.localWork == null) {
                return;
            }
            l4j.info((Object)"Initializing dummy operator");
            List<Operator<? extends OperatorDesc>> dummyOps = this.localWork.getDummyParentOp();
            for (Operator<? extends OperatorDesc> dummyOp : dummyOps) {
                dummyOp.setExecContext(this.execContext);
                dummyOp.initialize((Configuration)this.jc, null);
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map operator initialization failed", e);
        }
    }

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        if (this.oc == null) {
            this.oc = output;
            this.rp = reporter;
            this.mo.setOutputCollector(this.oc);
            this.mo.setReporter(this.rp);
            MapredContext.get().setReporter(reporter);
        }
        this.execContext.resetRow();
        try {
            if (this.mo.getDone()) {
                done = true;
            } else {
                this.mo.process((Writable)value);
                if (this.isLogInfoEnabled) {
                    ++this.numRows;
                    if (this.numRows == this.nextCntr) {
                        long used_memory = memoryMXBean.getHeapMemoryUsage().getUsed();
                        l4j.info((Object)("ExecMapper: processing " + this.numRows + " rows: used memory = " + used_memory));
                        this.nextCntr = this.getNextCntr(this.numRows);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.fatal((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private long getNextCntr(long cntr) {
        if (cntr >= 1000000L) {
            return cntr + 1000000L;
        }
        return 10L * cntr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.oc == null) {
            l4j.trace((Object)"Close called. no row processed by map.");
        }
        if (!this.abort) {
            this.abort = this.execContext.getIoCxt().getIOExceptions();
        }
        try {
            this.mo.close(this.abort);
            if (this.localWork != null) {
                List<Operator<? extends OperatorDesc>> dummyOps = this.localWork.getDummyParentOp();
                for (Operator<? extends OperatorDesc> operator : dummyOps) {
                    operator.close(this.abort);
                }
            }
            if (this.fetchOperators != null) {
                MapredLocalWork localWork = ((MapWork)this.mo.getConf()).getMapLocalWork();
                for (Map.Entry entry : this.fetchOperators.entrySet()) {
                    Operator<? extends OperatorDesc> forwardOp = localWork.getAliasToWork().get(entry.getKey());
                    forwardOp.close(this.abort);
                }
            }
            if (this.isLogInfoEnabled) {
                long used_memory = memoryMXBean.getHeapMemoryUsage().getUsed();
                l4j.info((Object)("ExecMapper: processed " + this.numRows + " rows: used memory = " + used_memory));
            }
            reportStats rps = new reportStats(this.rp);
            this.mo.preorderMap(rps);
            return;
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            MapredContext.close();
        }
    }

    public static boolean getDone() {
        return done;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public static void setDone(boolean done) {
        ExecMapper.done = done;
    }

    public static class reportStats
    implements Operator.OperatorFunc {
        Reporter rp;

        public reportStats(Reporter rp) {
            this.rp = rp;
        }

        public void func(Operator op) {
            Map<Enum<?>, Long> opStats = op.getStats();
            for (Map.Entry<Enum<?>, Long> e : opStats.entrySet()) {
                if (this.rp == null) continue;
                this.rp.incrCounter(e.getKey(), e.getValue().longValue());
            }
        }
    }
}

