/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

public abstract class HiveBaseChar {
    protected String value;
    protected int characterLength = -1;

    protected HiveBaseChar() {
    }

    public void setValue(String val, int maxLength) {
        this.characterLength = -1;
        this.value = HiveBaseChar.enforceMaxLength(val, maxLength);
    }

    public void setValue(HiveBaseChar val, int maxLength) {
        if (maxLength < 0 || val.characterLength > 0 && val.characterLength <= maxLength) {
            this.value = val.value;
            this.characterLength = val.characterLength;
        } else {
            this.setValue(val.value, maxLength);
        }
    }

    public static String enforceMaxLength(String val, int maxLength) {
        int valLength;
        String value = val;
        if (maxLength > 0 && (valLength = val.codePointCount(0, val.length())) > maxLength) {
            value = val.substring(0, val.offsetByCodePoints(0, maxLength));
        }
        return value;
    }

    public String getValue() {
        return this.value;
    }

    public int getCharacterLength() {
        if (this.characterLength < 0) {
            this.characterLength = this.value.codePointCount(0, this.value.length());
        }
        return this.characterLength;
    }
}

