/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.udaf.example;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="example_min", value="_FUNC_(expr) - Returns the minimum value of expr")
public class UDAFExampleMin
extends UDAF {

    public static class MinStringEvaluator
    implements UDAFEvaluator {
        private Text mMin;
        private boolean mEmpty;

        public MinStringEvaluator() {
            this.init();
        }

        public void init() {
            this.mMin = null;
            this.mEmpty = true;
        }

        public boolean iterate(Text o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMin = new Text(o);
                    this.mEmpty = false;
                } else if (ShimLoader.getHadoopShims().compareText(this.mMin, o) > 0) {
                    this.mMin.set(o);
                }
            }
            return true;
        }

        public Text terminatePartial() {
            return this.mEmpty ? null : this.mMin;
        }

        public boolean merge(Text o) {
            return this.iterate(o);
        }

        public Text terminate() {
            return this.mEmpty ? null : this.mMin;
        }
    }

    public static class MinDoubleEvaluator
    implements UDAFEvaluator {
        private double mMin;
        private boolean mEmpty;

        public MinDoubleEvaluator() {
            this.init();
        }

        public void init() {
            this.mMin = 0.0;
            this.mEmpty = true;
        }

        public boolean iterate(DoubleWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMin = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMin = Math.min(this.mMin, o.get());
                }
            }
            return true;
        }

        public DoubleWritable terminatePartial() {
            return this.mEmpty ? null : new DoubleWritable(this.mMin);
        }

        public boolean merge(DoubleWritable o) {
            return this.iterate(o);
        }

        public DoubleWritable terminate() {
            return this.mEmpty ? null : new DoubleWritable(this.mMin);
        }
    }

    public static class MinFloatEvaluator
    implements UDAFEvaluator {
        private float mMin;
        private boolean mEmpty;

        public MinFloatEvaluator() {
            this.init();
        }

        public void init() {
            this.mMin = 0.0f;
            this.mEmpty = true;
        }

        public boolean iterate(FloatWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMin = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMin = Math.min(this.mMin, o.get());
                }
            }
            return true;
        }

        public FloatWritable terminatePartial() {
            return this.mEmpty ? null : new FloatWritable(this.mMin);
        }

        public boolean merge(FloatWritable o) {
            return this.iterate(o);
        }

        public FloatWritable terminate() {
            return this.mEmpty ? null : new FloatWritable(this.mMin);
        }
    }

    public static class MinLongEvaluator
    implements UDAFEvaluator {
        private long mMin;
        private boolean mEmpty;

        public MinLongEvaluator() {
            this.init();
        }

        public void init() {
            this.mMin = 0L;
            this.mEmpty = true;
        }

        public boolean iterate(LongWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMin = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMin = Math.min(this.mMin, o.get());
                }
            }
            return true;
        }

        public LongWritable terminatePartial() {
            return this.mEmpty ? null : new LongWritable(this.mMin);
        }

        public boolean merge(LongWritable o) {
            return this.iterate(o);
        }

        public LongWritable terminate() {
            return this.mEmpty ? null : new LongWritable(this.mMin);
        }
    }

    public static class MinIntEvaluator
    implements UDAFEvaluator {
        private int mMin;
        private boolean mEmpty;

        public MinIntEvaluator() {
            this.init();
        }

        public void init() {
            this.mMin = 0;
            this.mEmpty = true;
        }

        public boolean iterate(IntWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMin = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMin = Math.min(this.mMin, o.get());
                }
            }
            return true;
        }

        public IntWritable terminatePartial() {
            return this.mEmpty ? null : new IntWritable(this.mMin);
        }

        public boolean merge(IntWritable o) {
            return this.iterate(o);
        }

        public IntWritable terminate() {
            return this.mEmpty ? null : new IntWritable(this.mMin);
        }
    }

    public static class MinShortEvaluator
    implements UDAFEvaluator {
        private short mMin;
        private boolean mEmpty;

        public MinShortEvaluator() {
            this.init();
        }

        public void init() {
            this.mMin = 0;
            this.mEmpty = true;
        }

        public boolean iterate(ShortWritable o) {
            if (o != null) {
                if (this.mEmpty) {
                    this.mMin = o.get();
                    this.mEmpty = false;
                } else {
                    this.mMin = (short)Math.min(this.mMin, o.get());
                }
            }
            return true;
        }

        public ShortWritable terminatePartial() {
            return this.mEmpty ? null : new ShortWritable(this.mMin);
        }

        public boolean merge(ShortWritable o) {
            return this.iterate(o);
        }

        public ShortWritable terminate() {
            return this.mEmpty ? null : new ShortWritable(this.mMin);
        }
    }
}

