/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.serde2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.contrib.util.typedbytes.Type;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesWritableInput;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesWritableOutput;
import org.apache.hadoop.hive.ql.io.NonSyncDataInputBuffer;
import org.apache.hadoop.hive.ql.io.NonSyncDataOutputBuffer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class TypedBytesSerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)TypedBytesSerDe.class.getName());
    int numColumns;
    StructObjectInspector rowOI;
    ArrayList<Object> row;
    BytesWritable serializeBytesWritable;
    NonSyncDataOutputBuffer barrStr;
    TypedBytesWritableOutput tbOut;
    NonSyncDataInputBuffer inBarrStr;
    TypedBytesWritableInput tbIn;
    List<String> columnNames;
    List<TypeInfo> columnTypes;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        int c;
        this.serializeBytesWritable = new BytesWritable();
        this.barrStr = new NonSyncDataOutputBuffer();
        this.tbOut = new TypedBytesWritableOutput((DataOutput)this.barrStr);
        this.inBarrStr = new NonSyncDataInputBuffer();
        this.tbIn = new TypedBytesWritableInput((DataInput)this.inBarrStr);
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnNames = Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = null;
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.numColumns = this.columnNames.size();
        for (int c2 = 0; c2 < this.numColumns; ++c2) {
            if (this.columnTypes.get(c2).getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new SerDeException(this.getClass().getName() + " only accepts primitive columns, but column[" + c2 + "] named " + this.columnNames.get(c2) + " has category " + this.columnTypes.get(c2).getCategory());
        }
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(this.columnNames.size());
        for (c = 0; c < this.numColumns; ++c) {
            columnOIs.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)this.columnTypes.get(c)));
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, columnOIs);
        this.row = new ArrayList(this.numColumns);
        for (c = 0; c < this.numColumns; ++c) {
            this.row.add(null);
        }
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        BytesWritable data = (BytesWritable)blob;
        this.inBarrStr.reset(data.getBytes(), 0, data.getLength());
        try {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                this.row.set(i, TypedBytesSerDe.deserializeField(this.tbIn, this.columnTypes.get(i), this.row.get(i)));
            }
            assert (this.tbIn.readTypeCode() == Type.ENDOFRECORD);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return this.row;
    }

    static Object deserializeField(TypedBytesWritableInput in, TypeInfo type, Object reuse) throws IOException {
        Class<? extends Writable> writableType = in.readType();
        if (writableType != null && writableType.isAssignableFrom(NullWritable.class)) {
            return null;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo ptype = (PrimitiveTypeInfo)type;
                switch (ptype.getPrimitiveCategory()) {
                    case VOID: {
                        return null;
                    }
                    case BOOLEAN: {
                        BooleanWritable r = reuse == null ? new BooleanWritable() : (BooleanWritable)reuse;
                        r = in.readBoolean(r);
                        return r;
                    }
                    case BYTE: {
                        ByteWritable r = reuse == null ? new ByteWritable() : (ByteWritable)reuse;
                        r = in.readByte(r);
                        return r;
                    }
                    case SHORT: {
                        ShortWritable r = reuse == null ? new ShortWritable() : (ShortWritable)reuse;
                        r = in.readShort(r);
                        return r;
                    }
                    case INT: {
                        IntWritable r = reuse == null ? new IntWritable() : (IntWritable)reuse;
                        r = in.readInt(r);
                        return r;
                    }
                    case LONG: {
                        LongWritable r = reuse == null ? new LongWritable() : (LongWritable)reuse;
                        r = in.readLong(r);
                        return r;
                    }
                    case FLOAT: {
                        FloatWritable r = reuse == null ? new FloatWritable() : (FloatWritable)reuse;
                        r = in.readFloat(r);
                        return r;
                    }
                    case DOUBLE: {
                        DoubleWritable r = reuse == null ? new DoubleWritable() : (DoubleWritable)reuse;
                        r = in.readDouble(r);
                        return r;
                    }
                    case STRING: {
                        Text r = reuse == null ? new Text() : (Text)reuse;
                        r = in.readText(r);
                        return r;
                    }
                }
                throw new RuntimeException("Unrecognized type: " + ptype.getPrimitiveCategory());
            }
        }
        throw new RuntimeException("Unsupported category: " + type.getCategory());
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        try {
            this.barrStr.reset();
            StructObjectInspector soi = (StructObjectInspector)objInspector;
            List fields = soi.getAllStructFieldRefs();
            for (int i = 0; i < this.numColumns; ++i) {
                Object o = soi.getStructFieldData(obj, (StructField)fields.get(i));
                ObjectInspector oi = ((StructField)fields.get(i)).getFieldObjectInspector();
                this.serializeField(o, oi, this.row.get(i));
            }
            this.tbOut.writeEndOfRecord();
            this.serializeBytesWritable.set(this.barrStr.getData(), 0, this.barrStr.getLength());
        }
        catch (IOException e) {
            throw new SerDeException(e.getMessage());
        }
        return this.serializeBytesWritable;
    }

    private void serializeField(Object o, ObjectInspector oi, Object reuse) throws IOException {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        return;
                    }
                    case BOOLEAN: {
                        BooleanObjectInspector boi = (BooleanObjectInspector)poi;
                        BooleanWritable r = reuse == null ? new BooleanWritable() : (BooleanWritable)reuse;
                        r.set(boi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case BYTE: {
                        ByteObjectInspector boi = (ByteObjectInspector)poi;
                        ByteWritable r = reuse == null ? new ByteWritable() : (ByteWritable)reuse;
                        r.set(boi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case SHORT: {
                        ShortObjectInspector spoi = (ShortObjectInspector)poi;
                        ShortWritable r = reuse == null ? new ShortWritable() : (ShortWritable)reuse;
                        r.set(spoi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case INT: {
                        IntObjectInspector ioi = (IntObjectInspector)poi;
                        IntWritable r = reuse == null ? new IntWritable() : (IntWritable)reuse;
                        r.set(ioi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case LONG: {
                        LongObjectInspector loi = (LongObjectInspector)poi;
                        LongWritable r = reuse == null ? new LongWritable() : (LongWritable)reuse;
                        r.set(loi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case FLOAT: {
                        FloatObjectInspector foi = (FloatObjectInspector)poi;
                        FloatWritable r = reuse == null ? new FloatWritable() : (FloatWritable)reuse;
                        r.set(foi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case DOUBLE: {
                        DoubleObjectInspector doi = (DoubleObjectInspector)poi;
                        DoubleWritable r = reuse == null ? new DoubleWritable() : (DoubleWritable)reuse;
                        r.set(doi.get(o));
                        this.tbOut.write((Writable)r);
                        return;
                    }
                    case STRING: {
                        StringObjectInspector soi = (StringObjectInspector)poi;
                        Text t = soi.getPrimitiveWritableObject(o);
                        this.tbOut.write((Writable)t);
                        return;
                    }
                }
                throw new RuntimeException("Unrecognized type: " + poi.getPrimitiveCategory());
            }
            case LIST: 
            case MAP: 
            case STRUCT: {
                String s = SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi);
                Text t = reuse == null ? new Text() : (Text)reuse;
                t.set(s);
                this.tbOut.write((Writable)t);
            }
        }
        throw new RuntimeException("Unrecognized type: " + oi.getCategory());
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

