/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;

@InterfaceAudience.Private
public class HFileCorruptionChecker {
    private static final Log LOG = LogFactory.getLog(HFileCorruptionChecker.class);
    final Configuration conf;
    final FileSystem fs;
    final CacheConfig cacheConf;
    final ExecutorService executor;
    final Set<Path> corrupted = new ConcurrentSkipListSet<Path>();
    final Set<Path> failures = new ConcurrentSkipListSet<Path>();
    final Set<Path> quarantined = new ConcurrentSkipListSet<Path>();
    final Set<Path> missing = new ConcurrentSkipListSet<Path>();
    final boolean inQuarantineMode;
    final AtomicInteger hfilesChecked = new AtomicInteger();

    public HFileCorruptionChecker(Configuration conf, ExecutorService executor, boolean quarantine) throws IOException {
        this.conf = conf;
        this.fs = FileSystem.get((Configuration)conf);
        this.cacheConf = new CacheConfig(conf);
        this.executor = executor;
        this.inQuarantineMode = quarantine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHFile(Path p) throws IOException {
        HFile.Reader r = null;
        try {
            r = HFile.createReader(this.fs, p, this.cacheConf, this.conf);
        }
        catch (CorruptHFileException che) {
            LOG.warn((Object)("Found corrupt HFile " + p), (Throwable)((Object)che));
            this.corrupted.add(p);
            if (this.inQuarantineMode) {
                Path dest = this.createQuarantinePath(p);
                LOG.warn((Object)("Quarantining corrupt HFile " + p + " into " + dest));
                boolean success = this.fs.mkdirs(dest.getParent());
                boolean bl = success = success ? this.fs.rename(p, dest) : false;
                if (!success) {
                    this.failures.add(p);
                } else {
                    this.quarantined.add(dest);
                }
            }
            return;
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn((Object)("HFile " + p + " was missing.  Likely removed due to compaction/split?"));
            this.missing.add(p);
        }
        finally {
            this.hfilesChecked.addAndGet(1);
            if (r != null) {
                r.close(true);
            }
        }
    }

    Path createQuarantinePath(Path hFile) throws IOException {
        Path cfDir = hFile.getParent();
        Path regionDir = cfDir.getParent();
        Path tableDir = regionDir.getParent();
        Path corruptBaseDir = new Path(FSUtils.getRootDir(this.conf), this.conf.get("hbase.hfile.quarantine.dir", "corrupt"));
        Path corruptTableDir = new Path(corruptBaseDir, tableDir.getName());
        Path corruptRegionDir = new Path(corruptTableDir, regionDir.getName());
        Path corruptFamilyDir = new Path(corruptRegionDir, cfDir.getName());
        Path corruptHfile = new Path(corruptFamilyDir, hFile.getName());
        return corruptHfile;
    }

    protected void checkColFamDir(Path cfDir) throws IOException {
        FileStatus[] hfs = null;
        try {
            hfs = this.fs.listStatus(cfDir, (PathFilter)new FSUtils.HFileFilter(this.fs));
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn((Object)("Colfam Directory " + cfDir + " does not exist.  Likely due to concurrent split/compaction. Skipping."));
            this.missing.add(cfDir);
            return;
        }
        if (hfs.length == 0 && !this.fs.exists(cfDir)) {
            LOG.warn((Object)("Colfam Directory " + cfDir + " does not exist.  Likely due to concurrent split/compaction. Skipping."));
            this.missing.add(cfDir);
            return;
        }
        for (FileStatus hfFs : hfs) {
            Path hf = hfFs.getPath();
            this.checkHFile(hf);
        }
    }

    protected void checkRegionDir(Path regionDir) throws IOException {
        FileStatus[] cfs = null;
        try {
            cfs = this.fs.listStatus(regionDir, (PathFilter)new FSUtils.FamilyDirFilter(this.fs));
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn((Object)("Region Directory " + regionDir + " does not exist.  Likely due to concurrent split/compaction. Skipping."));
            this.missing.add(regionDir);
            return;
        }
        if (cfs.length == 0 && !this.fs.exists(regionDir)) {
            LOG.warn((Object)("Region Directory " + regionDir + " does not exist.  Likely due to concurrent split/compaction. Skipping."));
            this.missing.add(regionDir);
            return;
        }
        for (FileStatus cfFs : cfs) {
            Path cfDir = cfFs.getPath();
            this.checkColFamDir(cfDir);
        }
    }

    void checkTableDir(Path tableDir) throws IOException {
        List rdFutures;
        FileStatus[] rds = this.fs.listStatus(tableDir, (PathFilter)new FSUtils.RegionDirFilter(this.fs));
        if (rds.length == 0 && !this.fs.exists(tableDir)) {
            LOG.warn((Object)("Table Directory " + tableDir + " does not exist.  Likely due to concurrent delete. Skipping."));
            this.missing.add(tableDir);
            return;
        }
        ArrayList<RegionDirChecker> rdcs = new ArrayList<RegionDirChecker>();
        for (FileStatus rdFs : rds) {
            Path rdDir = rdFs.getPath();
            RegionDirChecker work = new RegionDirChecker(rdDir);
            rdcs.add(work);
        }
        try {
            rdFutures = this.executor.invokeAll(rdcs);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn((Object)"Region dirs checking interrupted!", (Throwable)ie);
            return;
        }
        for (int i = 0; i < rdFutures.size(); ++i) {
            Future f = rdFutures.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn((Object)("Failed to quarantine an HFile in regiondir " + ((RegionDirChecker)rdcs.get((int)i)).regionDir), e.getCause());
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                LOG.error((Object)"Unexpected exception encountered", (Throwable)e);
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn((Object)"Region dirs check interrupted!", (Throwable)ie);
                return;
            }
        }
    }

    public void checkTables(Collection<Path> tables) throws IOException {
        for (Path t : tables) {
            this.checkTableDir(t);
        }
    }

    public Collection<Path> getFailures() {
        return new HashSet<Path>(this.failures);
    }

    public Collection<Path> getCorrupted() {
        return new HashSet<Path>(this.corrupted);
    }

    public int getHFilesChecked() {
        return this.hfilesChecked.get();
    }

    public Collection<Path> getQuarantined() {
        return new HashSet<Path>(this.quarantined);
    }

    public Collection<Path> getMissing() {
        return new HashSet<Path>(this.missing);
    }

    public void report(HBaseFsck.ErrorReporter out) {
        String fixedState;
        out.print("Checked " + this.hfilesChecked.get() + " hfile for corruption");
        out.print("  HFiles corrupted:                  " + this.corrupted.size());
        if (this.inQuarantineMode) {
            out.print("    HFiles successfully quarantined: " + this.quarantined.size());
            for (Path sq : this.quarantined) {
                out.print("      " + sq);
            }
            out.print("    HFiles failed quarantine:        " + this.failures.size());
            for (Path fq : this.failures) {
                out.print("      " + fq);
            }
        }
        out.print("    HFiles moved while checking:     " + this.missing.size());
        for (Path mq : this.missing) {
            out.print("      " + mq);
        }
        String initialState = this.corrupted.size() == 0 ? "OK" : "CORRUPTED";
        String string = fixedState = this.corrupted.size() == this.quarantined.size() ? "OK" : "CORRUPTED";
        if (this.inQuarantineMode) {
            out.print("Summary: " + initialState + " => " + fixedState);
        } else {
            out.print("Summary: " + initialState);
        }
    }

    private class RegionDirChecker
    implements Callable<Void> {
        final Path regionDir;

        RegionDirChecker(Path regionDir) {
            this.regionDir = regionDir;
        }

        @Override
        public Void call() throws IOException {
            HFileCorruptionChecker.this.checkRegionDir(this.regionDir);
            return null;
        }
    }
}

