// Autogenerated Jamon implementation
// /home/busbey/projects/hbase/hbase-assembly/target/hbase-1.2.6/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.ServerLoad;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 32, 9
import org.apache.hadoop.hbase.client.HConnectionManager;
// 33, 9
import org.apache.hadoop.hbase.HTableDescriptor;
// 34, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 35, 9
import org.apache.hadoop.hbase.util.VersionInfo;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 39, 1
    if ((servers != null && servers.size() > 0))
    {
      // 39, 47
      jamonWriter.write("\n\n");
      // 41, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 46, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 56, 13
      {
        // 56, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 56, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 59, 13
      {
        // 59, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 59, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 62, 13
      {
        // 62, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 62, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 65, 13
      {
        // 65, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 65, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
      // 68, 13
      {
        // 68, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 68, 62
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 73, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 172, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 176, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 183, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 189, 1
    jamonWriter.write("<tr>\n<td>");
    // 190, 5
    {
      // 190, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 190, 66
    jamonWriter.write("</td>\n<td>");
    // 191, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
    // 191, 59
    jamonWriter.write("</td>\n<td>");
    // 192, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
    // 192, 36
    jamonWriter.write("</td>\n<td>");
    // 193, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
    // 193, 37
    jamonWriter.write("</td>\n</tr>\n");
    // 195, 1
    
        }  else {
        
    // 198, 1
    {
      // 198, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 198, 40
    jamonWriter.write("\n");
    // 199, 1
    
        }
}

    // 203, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 306, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 310, 5
    jamonWriter.write("<tr>\n    <td>");
    // 311, 9
    {
      // 311, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
    }
    // 311, 72
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 289, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName, final ServerLoad serverLoad)
    throws java.io.IOException
  {
    // 294, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 299, 9
    if (infoPort > 0)
    {
      // 299, 28
      jamonWriter.write("\n            <a href=\"");
      // 300, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 300, 31
      jamonWriter.write("\">");
      // 300, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 300, 65
      jamonWriter.write("</a>\n        ");
    }
    // 301, 9
    else
    {
      // 301, 16
      jamonWriter.write("\n            ");
      // 302, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 302, 45
      jamonWriter.write("\n        ");
    }
    // 303, 15
    jamonWriter.write("\n");
  }
  
  
  // 135, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 139, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 147, 1
    
for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {

    // 153, 1
    jamonWriter.write("<tr>\n    <td>");
    // 154, 9
    {
      // 154, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 154, 70
    jamonWriter.write("</td>\n    <td>");
    // 155, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getUsedHeapMB()), jamonWriter);
    // 155, 33
    jamonWriter.write("m</td>\n    <td>");
    // 156, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getMaxHeapMB()), jamonWriter);
    // 156, 32
    jamonWriter.write("m</td>\n    <td>");
    // 157, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getMemstoreSizeInMB()), jamonWriter);
    // 157, 39
    jamonWriter.write("m</td>\n\n</tr>\n");
    // 160, 1
    
        }  else {

    // 163, 1
    {
      // 163, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 163, 40
    jamonWriter.write("\n");
    // 164, 1
    
        }
}

    // 168, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 75, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 79, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n");
    // 87, 1
    
    int totalRegions = 0;
    int totalRequests = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }
    
    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestsPerSecond();
        numRegionsOnline = sl.getNumberOfRegions();
        totalRegions += sl.getNumberOfRegions();
        // Is this correct?  Adding a rate to a measure.
        totalRequests += sl.getNumberOfRequests();
    }
    long startcode = serverName.getStartcode();

    // 112, 1
    jamonWriter.write("<tr>\n    <td>");
    // 113, 9
    {
      // 113, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 113, 70
    jamonWriter.write("</td>\n    <td>");
    // 114, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 114, 34
    jamonWriter.write("</td>\n    <td>");
    // 115, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 115, 22
    jamonWriter.write("</td>\n    <td>");
    // 116, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 116, 55
    jamonWriter.write("</td>\n    <td>");
    // 117, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 117, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 119, 1
    
}

    // 122, 1
    jamonWriter.write("<tr><td>Total:");
    // 122, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 122, 35
    jamonWriter.write("</td>\n<td></td>\n");
    // 124, 1
    if (inconsistentNodeNum > 0)
    {
      // 124, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 125, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 125, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 126, 1
    else
    {
      // 126, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 128, 7
    jamonWriter.write("\n<td>");
    // 129, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 129, 24
    jamonWriter.write("</td>\n<td>");
    // 130, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 130, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 247, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 251, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 259, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
String percentDone = "";
if  (sl.getTotalCompactingKVs() > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) sl.getCurrentCompactedKVs() / sl.getTotalCompactingKVs())) + "%";
}

    // 270, 1
    jamonWriter.write("<tr>\n<td>");
    // 271, 5
    {
      // 271, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 271, 66
    jamonWriter.write("</td>\n<td>");
    // 272, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
    // 272, 37
    jamonWriter.write("</td>\n<td>");
    // 273, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
    // 273, 38
    jamonWriter.write("</td>\n<td>");
    // 274, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
    // 274, 67
    jamonWriter.write("</td>\n<td>");
    // 275, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 275, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 277, 1
    
        }  else {
        
    // 280, 1
    {
      // 280, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 280, 40
    jamonWriter.write("\n");
    // 281, 1
    
    }
}

    // 285, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 207, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 211, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 221, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 227, 1
    jamonWriter.write("<tr>\n<td>");
    // 228, 5
    {
      // 228, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 228, 66
    jamonWriter.write("</td>\n<td>");
    // 229, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStores()), jamonWriter);
    // 229, 25
    jamonWriter.write("</td>\n<td>");
    // 230, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
    // 230, 29
    jamonWriter.write("</td>\n<td>");
    // 231, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStoreUncompressedSizeMB()), jamonWriter);
    // 231, 42
    jamonWriter.write("m</td>\n<td>");
    // 232, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefileSizeInMB()), jamonWriter);
    // 232, 36
    jamonWriter.write("mb</td>\n<td>");
    // 233, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalStaticIndexSizeKB()), jamonWriter);
    // 233, 41
    jamonWriter.write("k</td>\n<td>");
    // 234, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalStaticBloomSizeKB()), jamonWriter);
    // 234, 41
    jamonWriter.write("k</td>\n</tr>\n");
    // 236, 1
    
        }  else {
        
    // 239, 1
    {
      // 239, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 239, 40
    jamonWriter.write("\n");
    // 240, 1
    
    }
}

    // 244, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
