/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hbase.Tag;

/**
 * Interface to convert visibility expressions into Tags for storing along with Cells in HFiles.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface VisibilityExpressionResolver extends Configurable {

  /**
   * Giving a chance for the initialization.
   */
  void init();

  /**
   * Convert visibility expression into tags to be serialized.
   * @param visExpression the label expression
   * @return The list of tags corresponds to the visibility expression. These tags will be stored
   *         along with the Cells.
   */
  List<Tag> createVisibilityExpTags(String visExpression) throws IOException;
}
