/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ReversedScannerCallable
extends ScannerCallable {
    protected final byte[] locateStartRow;

    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, byte[] locateStartRow, RpcControllerFactory rpcFactory) {
        super(connection, tableName, scan, scanMetrics, rpcFactory);
        this.locateStartRow = locateStartRow;
    }

    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, byte[] locateStartRow, RpcControllerFactory rpcFactory, int replicaId) {
        super(connection, tableName, scan, scanMetrics, rpcFactory, replicaId);
        this.locateStartRow = locateStartRow;
    }

    @Deprecated
    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, byte[] locateStartRow) {
        this(connection, tableName, scan, scanMetrics, locateStartRow, RpcControllerFactory.instantiate(connection.getConfiguration()));
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (!this.instantiated || reload) {
            if (this.locateStartRow == null) {
                RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(!reload, this.id, this.getConnection(), this.getTableName(), this.getRow());
                HRegionLocation hRegionLocation = this.location = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
                if (this.location == null) {
                    throw new IOException("Failed to find location, tableName=" + this.tableName + ", row=" + Bytes.toStringBinary((byte[])this.row) + ", reload=" + reload);
                }
            } else {
                List<HRegionLocation> locatedRegions = this.locateRegionsInRange(this.locateStartRow, this.row, reload);
                if (locatedRegions.isEmpty()) {
                    throw new DoNotRetryIOException("Does hbase:meta exist hole? Couldn't get regions for the range from " + Bytes.toStringBinary((byte[])this.locateStartRow) + " to " + Bytes.toStringBinary((byte[])this.row));
                }
                this.location = locatedRegions.get(locatedRegions.size() - 1);
            }
            this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.incrementAndGet();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
            }
        }
    }

    private List<HRegionLocation> locateRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(!reload, this.id, this.getConnection(), this.getTableName(), currentKey);
            HRegionLocation hRegionLocation = regionLocation = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
            if (regionLocation == null || !regionLocation.getRegionInfo().containsRow(currentKey)) {
                throw new DoNotRetryIOException("Does hbase:meta exist hole? Locating row " + Bytes.toStringBinary((byte[])currentKey) + " returns incorrect region " + regionLocation.getRegionInfo());
            }
            regionList.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
        return regionList;
    }

    @Override
    public ScannerCallable getScannerCallableForReplica(int id) {
        ReversedScannerCallable r = new ReversedScannerCallable(this.cConnection, this.tableName, this.getScan(), this.scanMetrics, this.locateStartRow, this.controllerFactory, id);
        r.setCaching(this.getCaching());
        return r;
    }
}

