/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.TestDistCpWithXAttrs;
import org.apache.hadoop.tools.util.DistCpTestUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCpWithXAttrs {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;
    private static final String name1 = "user.a1";
    private static final byte[] value1;
    private static final String name2 = "trusted.a2";
    private static final byte[] value2;
    private static final String name3 = "user.a3";
    private static final byte[] value3;
    private static final String name4 = "user.a4";
    private static final byte[] value4;
    private static final Path dir1;
    private static final Path subDir1;
    private static final Path file1;
    private static final Path dir2;
    private static final Path file2;
    private static final Path file3;
    private static final Path file4;
    private static final Path dstDir1;
    private static final Path dstSubDir1;
    private static final Path dstFile1;
    private static final Path dstDir2;
    private static final Path dstFile2;
    private static final Path dstFile3;
    private static final Path dstFile4;
    private static final String rootedSrcName = "/src";

    @BeforeClass
    public static void init() throws Exception {
        TestDistCpWithXAttrs.initCluster((boolean)true, (boolean)true);
        fs.mkdirs(subDir1);
        fs.create(file1).close();
        fs.mkdirs(dir2);
        fs.create(file2).close();
        fs.create(file3).close();
        fs.create(file4).close();
        fs.setXAttr(dir1, "user.a1", value1);
        fs.setXAttr(dir1, "trusted.a2", value2);
        fs.setXAttr(subDir1, "user.a1", value1);
        fs.setXAttr(subDir1, "user.a3", value3);
        fs.setXAttr(file1, "user.a1", value1);
        fs.setXAttr(file1, "trusted.a2", value2);
        fs.setXAttr(file1, "user.a3", value3);
        fs.setXAttr(dir2, "trusted.a2", value2);
        fs.setXAttr(file2, "user.a1", value1);
        fs.setXAttr(file2, "user.a4", value4);
        fs.setXAttr(file3, "user.a3", value3);
        fs.setXAttr(file3, "user.a4", value4);
    }

    @AfterClass
    public static void shutdown() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testPreserveXAttrs() throws Exception {
        DistCpTestUtils.assertRunDistCp((int)0, (String)"/src", (String)"/dstPreserveXAttrs", (String)"-px", (Configuration)conf);
        HashMap xAttrs = Maps.newHashMap();
        xAttrs.put("user.a1", value1);
        xAttrs.put("trusted.a2", value2);
        DistCpTestUtils.assertXAttrs((Path)dstDir1, (FileSystem)fs, (Map)xAttrs);
        xAttrs.clear();
        xAttrs.put("user.a1", value1);
        xAttrs.put("user.a3", new byte[0]);
        DistCpTestUtils.assertXAttrs((Path)dstSubDir1, (FileSystem)fs, (Map)xAttrs);
        xAttrs.clear();
        xAttrs.put("user.a1", value1);
        xAttrs.put("trusted.a2", value2);
        xAttrs.put("user.a3", new byte[0]);
        DistCpTestUtils.assertXAttrs((Path)dstFile1, (FileSystem)fs, (Map)xAttrs);
        xAttrs.clear();
        xAttrs.put("trusted.a2", value2);
        DistCpTestUtils.assertXAttrs((Path)dstDir2, (FileSystem)fs, (Map)xAttrs);
        xAttrs.clear();
        xAttrs.put("user.a1", value1);
        xAttrs.put("user.a4", new byte[0]);
        DistCpTestUtils.assertXAttrs((Path)dstFile2, (FileSystem)fs, (Map)xAttrs);
        xAttrs.clear();
        xAttrs.put("user.a3", new byte[0]);
        xAttrs.put("user.a4", new byte[0]);
        DistCpTestUtils.assertXAttrs((Path)dstFile3, (FileSystem)fs, (Map)xAttrs);
        xAttrs.clear();
        DistCpTestUtils.assertXAttrs((Path)dstFile4, (FileSystem)fs, (Map)xAttrs);
    }

    @Test
    public void testXAttrsNotEnabled() throws Exception {
        try {
            TestDistCpWithXAttrs.restart((boolean)false);
            DistCpTestUtils.assertRunDistCp((int)-4, (String)"/src", (String)"/dstXAttrsNotEnabled", (String)"-px", (Configuration)conf);
        }
        finally {
            TestDistCpWithXAttrs.restart((boolean)true);
        }
    }

    @Test
    public void testXAttrsNotImplemented() throws Exception {
        DistCpTestUtils.assertRunDistCp((int)-4, (String)"/src", (String)"stubfs://dstXAttrsNotImplemented", (String)"-px", (Configuration)conf);
    }

    private static void initCluster(boolean format, boolean xAttrsEnabled) throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", xAttrsEnabled);
        conf.set("fs.defaultFS", "stubfs:///");
        conf.setClass("fs.stubfs.impl", StubFileSystem.class, FileSystem.class);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    private static void restart(boolean xAttrsEnabled) throws Exception {
        TestDistCpWithXAttrs.shutdown();
        TestDistCpWithXAttrs.initCluster((boolean)false, (boolean)xAttrsEnabled);
    }

    static {
        value1 = new byte[]{49, 50, 51};
        value2 = new byte[]{55, 56, 57};
        value3 = null;
        value4 = null;
        dir1 = new Path("/src/dir1");
        subDir1 = new Path(dir1, "subdir1");
        file1 = new Path("/src/file1");
        dir2 = new Path("/src/dir2");
        file2 = new Path(dir2, "file2");
        file3 = new Path(dir2, "file3");
        file4 = new Path(dir2, "file4");
        dstDir1 = new Path("/dstPreserveXAttrs/dir1");
        dstSubDir1 = new Path(dstDir1, "subdir1");
        dstFile1 = new Path("/dstPreserveXAttrs/file1");
        dstDir2 = new Path("/dstPreserveXAttrs/dir2");
        dstFile2 = new Path(dstDir2, "file2");
        dstFile3 = new Path(dstDir2, "file3");
        dstFile4 = new Path(dstDir2, "file4");
    }
}

