/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.TestDistCpSystem;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCpSystem
extends TestCase {
    private static final String SRCDAT = "srcdat";
    private static final String DSTDAT = "dstdat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(FileSystem fs, String topdir, FileEntry[] entries) throws IOException {
        for (FileEntry entry : entries) {
            Path newpath = new Path(topdir + "/" + entry.getPath());
            if (entry.isDirectory()) {
                fs.mkdirs(newpath);
                continue;
            }
            try (FSDataOutputStream out = fs.create(newpath);){
                out.write((topdir + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, FileEntry[] files) throws IOException {
        Path root = new Path(topdir);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (int idx = 0; idx < files.length; ++idx) {
            Path newpath = new Path(root, files[idx].getPath());
            statuses.add(fs.getFileStatus(newpath));
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPreserveUserHelper(FileEntry[] srcEntries, FileEntry[] dstEntries, boolean createSrcDir, boolean createTgtDir, boolean update) throws Exception {
        Configuration conf = null;
        MiniDFSCluster cluster = null;
        try {
            String[] stringArray;
            String testRoot = "/testdir";
            String testSrcRel = "srcdat";
            String testSrc = "/testdir/srcdat";
            String testDstRel = "dstdat";
            String testDst = "/testdir/dstdat";
            conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            fs.mkdirs(new Path("/testdir"));
            if (createSrcDir) {
                fs.mkdirs(new Path("/testdir/srcdat"));
            }
            if (createTgtDir) {
                fs.mkdirs(new Path("/testdir/dstdat"));
            }
            this.createFiles(fs, "/testdir", srcEntries);
            FileStatus[] srcstats = TestDistCpSystem.getFileStatus((FileSystem)fs, (String)"/testdir", (FileEntry[])srcEntries);
            for (int i = 0; i < srcEntries.length; ++i) {
                fs.setOwner(srcstats[i].getPath(), "u" + i, null);
            }
            if (update) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "-pu";
                stringArray2[1] = "-update";
                stringArray2[2] = nnUri + "/testdir/srcdat";
                stringArray = stringArray2;
                stringArray2[3] = nnUri + "/testdir/dstdat";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "-pu";
                stringArray3[1] = nnUri + "/testdir/srcdat";
                stringArray = stringArray3;
                stringArray3[2] = nnUri + "/testdir/dstdat";
            }
            String[] args = stringArray;
            ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args);
            String realTgtPath = "/testdir/dstdat";
            if (!createTgtDir) {
                realTgtPath = "/testdir";
            }
            FileStatus[] dststat = TestDistCpSystem.getFileStatus((FileSystem)fs, (String)realTgtPath, (FileEntry[])dstEntries);
            for (int i = 0; i < dststat.length; ++i) {
                TestDistCpSystem.assertEquals((String)("i=" + i), (String)("u" + i), (String)dststat[i].getOwner());
            }
            TestDistCpSystem.deldir((FileSystem)fs, (String)"/testdir");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testPreserveUseNonEmptyDir() throws Exception {
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(this, "srcdat", true), new FileEntry(this, "srcdat/a", false), new FileEntry(this, "srcdat/b", true), new FileEntry(this, "srcdat/b/c", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(this, "dstdat", true), new FileEntry(this, "dstdat/a", false), new FileEntry(this, "dstdat/b", true), new FileEntry(this, "dstdat/b/c", false)};
        this.testPreserveUserHelper(srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(srcfiles, dstfiles, false, false, false);
    }

    public void testPreserveUserEmptyDir() throws Exception {
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(this, "srcdat", true)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(this, "dstdat", true)};
        this.testPreserveUserHelper(srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(srcfiles, dstfiles, false, false, false);
    }

    public void testPreserveUserSingleFile() throws Exception {
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(this, "srcdat", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(this, "dstdat", false)};
        this.testPreserveUserHelper(srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(srcfiles, dstfiles, false, false, false);
    }

    public void testPreserveUserNonEmptyDirWithUpdate() throws Exception {
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(this, "srcdat/a", false), new FileEntry(this, "srcdat/b", true), new FileEntry(this, "srcdat/b/c", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(this, "a", false), new FileEntry(this, "b", true), new FileEntry(this, "b/c", false)};
        this.testPreserveUserHelper(srcfiles, dstfiles, true, true, true);
    }
}

