/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Count
extends FsCommand {
    private static final String OPTION_QUOTA = "q";
    private static final String OPTION_HUMAN = "h";
    private static final String OPTION_HEADER = "v";
    private static final String OPTION_TYPE = "t";
    private static final String OPTION_EXCLUDE_SNAPSHOT = "x";
    private static final String OPTION_QUOTA_AND_USAGE = "u";
    private static final String OPTION_ECPOLICY = "e";
    private static final String OPTION_SNAPSHOT_COUNT = "s";
    public static final String NAME = "count";
    public static final String USAGE = "[-q] [-h] [-v] [-t [<storage type>]] [-u] [-x] [-e] [-s] <path> ...";
    public static final String DESCRIPTION = "Count the number of directories, files and bytes under the paths\nthat match the specified file pattern.  The output columns are:\n" + StringUtils.join((Object[])ContentSummary.getHeaderFields(), (char)' ') + " PATHNAME\nor, with the -" + "q" + " option:\n" + StringUtils.join((Object[])ContentSummary.getQuotaHeaderFields(), (char)' ') + "\n      " + StringUtils.join((Object[])ContentSummary.getHeaderFields(), (char)' ') + " PATHNAME\nThe -" + "h" + " option shows file sizes in human readable format.\nThe -" + "v" + " option displays a header line.\nThe -" + "x" + " option excludes snapshots from being calculated. \nThe -" + "t" + " option displays quota by storage types.\nIt should be used with -" + "q" + " or -" + "u" + " option, otherwise it will be ignored.\nIf a comma-separated list of storage types is given after the -" + "t" + " option, \nit displays the quota and usage for the specified types. \nOtherwise, it displays the quota and usage for all the storage \ntypes that support quota. The list of possible storage types(case insensitive):\nram_disk, ssd, disk, archive and nvdimm.\nIt can also pass the value '', 'all' or 'ALL' to specify all the storage types.\nThe -" + "u" + " option shows the quota and \nthe usage against the quota without the detailed content summary.The -" + "e" + " option shows the erasure coding policy.The -" + "s" + " option shows snapshot counts.";
    private boolean showQuotas;
    private boolean humanReadable;
    private boolean showQuotabyType;
    private List<StorageType> storageTypes = null;
    private boolean showQuotasAndUsageOnly;
    private boolean excludeSnapshots;
    private boolean displayECPolicy;
    private boolean showSnapshot;

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Count.class, "-count");
    }

    public Count() {
    }

    @Deprecated
    public Count(String[] cmd, int pos, Configuration conf) {
        super(conf);
        this.args = Arrays.copyOfRange(cmd, pos, cmd.length);
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, OPTION_QUOTA, OPTION_HUMAN, OPTION_HEADER, OPTION_QUOTA_AND_USAGE, OPTION_EXCLUDE_SNAPSHOT, OPTION_ECPOLICY, OPTION_SNAPSHOT_COUNT);
        cf.addOptionWithValue(OPTION_TYPE);
        cf.parse(args);
        if (args.isEmpty()) {
            args.add(".");
        }
        this.showQuotas = cf.getOpt(OPTION_QUOTA);
        this.humanReadable = cf.getOpt(OPTION_HUMAN);
        this.showQuotasAndUsageOnly = cf.getOpt(OPTION_QUOTA_AND_USAGE);
        this.excludeSnapshots = cf.getOpt(OPTION_EXCLUDE_SNAPSHOT);
        this.displayECPolicy = cf.getOpt(OPTION_ECPOLICY);
        this.showSnapshot = cf.getOpt(OPTION_SNAPSHOT_COUNT);
        if (this.showQuotas || this.showQuotasAndUsageOnly) {
            String types = cf.getOptValue(OPTION_TYPE);
            if (null != types) {
                this.showQuotabyType = true;
                this.storageTypes = this.getAndCheckStorageTypes(types);
            } else {
                this.showQuotabyType = false;
            }
            if (this.excludeSnapshots) {
                this.out.println("q or u option is given, the -x option is ignored.");
                this.excludeSnapshots = false;
            }
        }
        if (cf.getOpt(OPTION_HEADER)) {
            StringBuilder headString = new StringBuilder();
            if (this.showQuotabyType) {
                headString.append(QuotaUsage.getStorageTypeHeader(this.storageTypes));
            } else if (this.showQuotasAndUsageOnly) {
                headString.append(QuotaUsage.getHeader());
            } else {
                headString.append(ContentSummary.getHeader(this.showQuotas));
            }
            if (this.displayECPolicy) {
                headString.append(ContentSummary.getErasureCodingPolicyHeader());
            }
            if (this.showSnapshot) {
                headString.append(ContentSummary.getSnapshotHeader());
            }
            headString.append("PATHNAME");
            this.out.println(headString.toString());
        }
    }

    private List<StorageType> getAndCheckStorageTypes(String types) {
        if ("".equals(types) || "all".equalsIgnoreCase(types)) {
            return StorageType.getTypesSupportingQuota();
        }
        String[] typeArray = StringUtils.split((String)types, (char)',');
        ArrayList<StorageType> stTypes = new ArrayList<StorageType>();
        for (String t : typeArray) {
            stTypes.add(StorageType.parseStorageType(t));
        }
        return stTypes;
    }

    @Override
    protected void processPath(PathData src) throws IOException {
        ContentSummary summary;
        StringBuilder outputString = new StringBuilder();
        if (this.showQuotasAndUsageOnly || this.showQuotabyType) {
            QuotaUsage usage = src.fs.getQuotaUsage(src.path);
            outputString.append(usage.toString(this.isHumanReadable(), this.showQuotabyType, this.storageTypes));
        } else {
            summary = src.fs.getContentSummary(src.path);
            outputString.append(summary.toString(this.showQuotas, this.isHumanReadable(), this.excludeSnapshots));
        }
        if (this.displayECPolicy) {
            summary = src.fs.getContentSummary(src.path);
            outputString.append(summary.toErasureCodingPolicy());
        }
        if (this.showSnapshot) {
            summary = src.fs.getContentSummary(src.path);
            outputString.append(summary.toSnapshot(this.isHumanReadable()));
        }
        outputString.append(src);
        this.out.println(outputString.toString());
    }

    @InterfaceAudience.Private
    boolean isShowQuotas() {
        return this.showQuotas;
    }

    @InterfaceAudience.Private
    boolean isHumanReadable() {
        return this.humanReadable;
    }

    @InterfaceAudience.Private
    boolean isShowQuotabyType() {
        return this.showQuotabyType;
    }

    @InterfaceAudience.Private
    List<StorageType> getStorageTypes() {
        return this.storageTypes;
    }
}

