/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.random;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OsSecureRandom
extends Random
implements Closeable,
Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(OsSecureRandom.class);
    private static final long serialVersionUID = 6391500337172057900L;
    private transient Configuration conf;
    private final int RESERVOIR_LENGTH = 8192;
    private String randomDevPath;
    private transient InputStream stream;
    private final byte[] reservoir = new byte[8192];
    private int pos = this.reservoir.length;

    private void fillReservoir(int min) {
        if (this.pos >= this.reservoir.length - min) {
            try {
                if (this.stream == null) {
                    this.stream = Files.newInputStream(Paths.get(this.randomDevPath, new String[0]), new OpenOption[0]);
                }
                IOUtils.readFully(this.stream, this.reservoir, 0, this.reservoir.length);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to fill reservoir", e);
            }
            this.pos = 0;
        }
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.stream == null;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
        this.randomDevPath = conf.get("hadoop.security.random.device.file.path", "/dev/urandom");
        this.close();
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        int off = 0;
        int n = 0;
        while (off < bytes.length) {
            this.fillReservoir(0);
            n = Math.min(bytes.length - off, this.reservoir.length - this.pos);
            System.arraycopy(this.reservoir, this.pos, bytes, off, n);
            off += n;
            this.pos += n;
        }
    }

    @Override
    protected synchronized int next(int nbits) {
        this.fillReservoir(4);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | this.reservoir[this.pos++] & 0xFF;
        }
        return n & -1 >> 32 - nbits;
    }

    @Override
    public synchronized void close() {
        if (this.stream != null) {
            IOUtils.cleanupWithLogger(LOG, this.stream);
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

