/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.security.GeneralSecurityException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.crypto.OpensslCtrCryptoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OpensslSm4CtrCryptoCodec
extends OpensslCtrCryptoCodec {
    private static final Logger LOG = LoggerFactory.getLogger((String)OpensslSm4CtrCryptoCodec.class.getName());

    public OpensslSm4CtrCryptoCodec() {
        String loadingFailureReason = OpensslCipher.getLoadingFailureReason();
        if (loadingFailureReason != null) {
            throw new RuntimeException(loadingFailureReason);
        }
        if (!OpensslCipher.isSupported(CipherSuite.SM4_CTR_NOPADDING)) {
            throw new RuntimeException("The OpenSSL native library is built without SM4 CTR support");
        }
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.setEngineId(conf.get("hadoop.security.openssl.engine.id"));
    }

    @Override
    public CipherSuite getCipherSuite() {
        return CipherSuite.SM4_CTR_NOPADDING;
    }

    @Override
    public void calculateIV(byte[] initIV, long counter, byte[] iv) {
        super.calculateIV(initIV, counter, iv, this.getCipherSuite().getAlgorithmBlockSize());
    }

    @Override
    public Encryptor createEncryptor() throws GeneralSecurityException {
        return new OpensslCtrCryptoCodec.OpensslCtrCipher(1, this.getCipherSuite(), this.getEngineId());
    }

    @Override
    public Decryptor createDecryptor() throws GeneralSecurityException {
        return new OpensslCtrCryptoCodec.OpensslCtrCipher(0, this.getCipherSuite(), this.getEngineId());
    }
}

