/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRPCCompatibility {
    private static final String ADDRESS = "0.0.0.0";
    private static InetSocketAddress addr;
    private static RPC.Server server;
    private ProtocolProxy<?> proxy;
    public static final Logger LOG;
    private static Configuration conf;

    @Before
    public void setUp() {
        ProtocolSignature.resetCache();
        RPC.setProtocolEngine((Configuration)conf, TestProtocol0.class, ProtobufRpcEngine.class);
        RPC.setProtocolEngine((Configuration)conf, TestProtocol1.class, ProtobufRpcEngine.class);
        RPC.setProtocolEngine((Configuration)conf, TestProtocol2.class, ProtobufRpcEngine.class);
        RPC.setProtocolEngine((Configuration)conf, TestProtocol3.class, ProtobufRpcEngine.class);
        RPC.setProtocolEngine((Configuration)conf, TestProtocol4.class, ProtobufRpcEngine.class);
    }

    @After
    public void tearDown() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy.getProxy());
            this.proxy = null;
        }
        if (server != null) {
            server.stop();
            server = null;
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Method strMethod = TestProtocol3.class.getMethod("echo", String.class);
        int stringEchoHash = ProtocolSignature.getFingerprint((Method)strMethod);
        Method intMethod = TestProtocol3.class.getMethod("echo", Integer.TYPE);
        int intEchoHash = ProtocolSignature.getFingerprint((Method)intMethod);
        Assert.assertFalse((stringEchoHash == intEchoHash ? 1 : 0) != 0);
        int intEchoHash1 = ProtocolSignature.getFingerprint((Method)TestProtocol2.class.getMethod("echo", Integer.TYPE));
        Assert.assertEquals((long)intEchoHash, (long)intEchoHash1);
        int stringEchoHash1 = ProtocolSignature.getFingerprint((Method)TestProtocol2.class.getMethod("echo", String.class));
        Assert.assertFalse((stringEchoHash == stringEchoHash1 ? 1 : 0) != 0);
        int intEchoHashAlias = ProtocolSignature.getFingerprint((Method)TestProtocol3.class.getMethod("echo_alias", Integer.TYPE));
        Assert.assertFalse((intEchoHash == intEchoHashAlias ? 1 : 0) != 0);
        int intEchoHash2 = ProtocolSignature.getFingerprint((Method)TestProtocol3.class.getMethod("echo", Integer.TYPE, Integer.TYPE));
        Assert.assertFalse((intEchoHash == intEchoHash2 ? 1 : 0) != 0);
        int hash1 = ProtocolSignature.getFingerprint((Method[])new Method[]{intMethod, strMethod});
        int hash2 = ProtocolSignature.getFingerprint((Method[])new Method[]{strMethod, intMethod});
        Assert.assertEquals((long)hash1, (long)hash2);
    }

    static {
        LOG = LoggerFactory.getLogger(TestRPCCompatibility.class);
        conf = new Configuration();
    }

    @ProtocolInfo(protocolName="org.apache.hadoop.ipc.TestRPCCompatibility$TestProtocol1")
    public static interface TestProtocol4
    extends TestProtocol2 {
        public static final long versionID = 4L;

        @Override
        public int echo(int var1) throws IOException;
    }

    public static interface TestProtocol3 {
        public int echo(String var1);

        public int echo(int var1);

        public int echo_alias(int var1);

        public int echo(int var1, int var2);
    }

    public static class TestImpl2
    extends TestImpl1
    implements TestProtocol2 {
        @Override
        public int echo(int value) {
            return value;
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }
    }

    public static class TestImpl1
    extends TestImpl0
    implements TestProtocol1 {
        @Override
        public String echo(String value) {
            return value;
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }
    }

    public static class TestImpl0
    implements TestProtocol0 {
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHashCode) throws IOException {
            Class inter;
            try {
                inter = (Class)this.getClass().getGenericInterfaces()[0];
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return ProtocolSignature.getProtocolSignature((int)clientMethodsHashCode, (long)this.getProtocolVersion(protocol, clientVersion), (Class)inter);
        }

        @Override
        public void ping() {
        }
    }

    @ProtocolInfo(protocolName="org.apache.hadoop.ipc.TestRPCCompatibility$TestProtocol1")
    public static interface TestProtocol2
    extends TestProtocol1 {
        public int echo(int var1) throws IOException;
    }

    public static interface TestProtocol1
    extends TestProtocol0 {
        public String echo(String var1) throws IOException;
    }

    public static interface TestProtocol0
    extends VersionedProtocol {
        public static final long versionID = 0L;

        public void ping() throws IOException;
    }
}

