/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCodecPool {
    private final String LEASE_COUNT_ERR = "Incorrect number of leased (de)compressors";
    DefaultCodec codec;

    @Before
    public void setup() {
        this.codec = new DefaultCodec();
        this.codec.setConf(new Configuration());
    }

    @Test(timeout=10000L)
    public void testCompressorPoolCounts() {
        Compressor comp1 = CodecPool.getCompressor((CompressionCodec)this.codec);
        Compressor comp2 = CodecPool.getCompressor((CompressionCodec)this.codec);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)2L, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)this.codec));
        CodecPool.returnCompressor((Compressor)comp2);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)1L, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)this.codec));
        CodecPool.returnCompressor((Compressor)comp1);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)this.codec));
        CodecPool.returnCompressor((Compressor)comp1);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)this.codec));
    }

    @Test(timeout=10000L)
    public void testCompressorNotReturnSameInstance() {
        Compressor comp = CodecPool.getCompressor((CompressionCodec)this.codec);
        CodecPool.returnCompressor((Compressor)comp);
        CodecPool.returnCompressor((Compressor)comp);
        HashSet<Compressor> compressors = new HashSet<Compressor>();
        for (int i = 0; i < 10; ++i) {
            compressors.add(CodecPool.getCompressor((CompressionCodec)this.codec));
        }
        Assert.assertEquals((long)10L, (long)compressors.size());
        for (Compressor compressor : compressors) {
            CodecPool.returnCompressor((Compressor)compressor);
        }
    }

    @Test(timeout=10000L)
    public void testDecompressorPoolCounts() {
        Decompressor decomp1 = CodecPool.getDecompressor((CompressionCodec)this.codec);
        Decompressor decomp2 = CodecPool.getDecompressor((CompressionCodec)this.codec);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)2L, (long)CodecPool.getLeasedDecompressorsCount((CompressionCodec)this.codec));
        CodecPool.returnDecompressor((Decompressor)decomp2);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)1L, (long)CodecPool.getLeasedDecompressorsCount((CompressionCodec)this.codec));
        CodecPool.returnDecompressor((Decompressor)decomp1);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedDecompressorsCount((CompressionCodec)this.codec));
        CodecPool.returnDecompressor((Decompressor)decomp1);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)this.codec));
    }

    @Test(timeout=10000L)
    public void testMultiThreadedCompressorPool() throws InterruptedException {
        int iterations = 4;
        ExecutorService threadpool = Executors.newFixedThreadPool(3);
        final LinkedBlockingDeque queue = new LinkedBlockingDeque(8);
        Callable<Boolean> consumer = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Compressor c = (Compressor)queue.take();
                CodecPool.returnCompressor((Compressor)c);
                return c != null;
            }
        };
        Callable<Boolean> producer = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Compressor c = CodecPool.getCompressor((CompressionCodec)TestCodecPool.this.codec);
                queue.put(c);
                return c != null;
            }
        };
        for (int i = 0; i < 4; ++i) {
            threadpool.submit(consumer);
            threadpool.submit(producer);
        }
        threadpool.shutdown();
        threadpool.awaitTermination(1000L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)this.codec));
    }

    @Test(timeout=10000L)
    public void testMultiThreadedDecompressorPool() throws InterruptedException {
        int iterations = 4;
        ExecutorService threadpool = Executors.newFixedThreadPool(3);
        final LinkedBlockingDeque queue = new LinkedBlockingDeque(8);
        Callable<Boolean> consumer = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Decompressor dc = (Decompressor)queue.take();
                CodecPool.returnDecompressor((Decompressor)dc);
                return dc != null;
            }
        };
        Callable<Boolean> producer = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Decompressor c = CodecPool.getDecompressor((CompressionCodec)TestCodecPool.this.codec);
                queue.put(c);
                return c != null;
            }
        };
        for (int i = 0; i < 4; ++i) {
            threadpool.submit(consumer);
            threadpool.submit(producer);
        }
        threadpool.shutdown();
        threadpool.awaitTermination(1000L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedDecompressorsCount((CompressionCodec)this.codec));
    }

    @Test(timeout=10000L)
    public void testDecompressorNotReturnSameInstance() {
        Decompressor decomp = CodecPool.getDecompressor((CompressionCodec)this.codec);
        CodecPool.returnDecompressor((Decompressor)decomp);
        CodecPool.returnDecompressor((Decompressor)decomp);
        HashSet<Decompressor> decompressors = new HashSet<Decompressor>();
        for (int i = 0; i < 10; ++i) {
            decompressors.add(CodecPool.getDecompressor((CompressionCodec)this.codec));
        }
        Assert.assertEquals((long)10L, (long)decompressors.size());
        for (Decompressor decompressor : decompressors) {
            CodecPool.returnDecompressor((Decompressor)decompressor);
        }
    }
}

