/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.NoVersionAttributeException;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ChangeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeTracker.class);
    public static final String CHANGE_REPORTED_BY_S3 = "reported by S3";
    private final ChangeDetectionPolicy policy;
    private final String uri;
    private final AtomicLong versionMismatches;
    private String revisionId;

    public ChangeTracker(String uri, ChangeDetectionPolicy policy, AtomicLong versionMismatches) {
        this.policy = (ChangeDetectionPolicy)Preconditions.checkNotNull((Object)policy);
        this.uri = uri;
        this.versionMismatches = versionMismatches;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public ChangeDetectionPolicy.Source getSource() {
        return this.policy.getSource();
    }

    @VisibleForTesting
    public AtomicLong getVersionMismatches() {
        return this.versionMismatches;
    }

    public boolean maybeApplyConstraint(GetObjectRequest request) {
        if (this.policy.getMode() == ChangeDetectionPolicy.Mode.Server && this.revisionId != null) {
            this.policy.applyRevisionConstraint(request, this.revisionId);
            return true;
        }
        return false;
    }

    public void processResponse(S3Object object, String operation, long pos) throws PathIOException {
        if (object == null) {
            if (this.revisionId != null) {
                this.versionMismatches.incrementAndGet();
                throw new RemoteFileChangedException(this.uri, operation, String.format("%s change reported by S3 while reading at position %s. Version %s was unavailable", new Object[]{this.getSource(), pos, this.getRevisionId()}));
            }
            throw new PathIOException(this.uri, "No data returned from GET request");
        }
        ObjectMetadata metadata = object.getObjectMetadata();
        String newRevisionId = this.policy.getRevisionId(metadata, this.uri);
        if (newRevisionId == null && this.policy.isRequireVersion()) {
            throw new NoVersionAttributeException(this.uri, String.format("Change detection policy requires %s", new Object[]{this.policy.getSource()}));
        }
        if (this.revisionId == null) {
            LOG.debug("Setting revision ID for object at {}: {}", (Object)this.uri, (Object)newRevisionId);
            this.revisionId = newRevisionId;
        } else if (!this.revisionId.equals(newRevisionId)) {
            LOG.debug("Revision ID changed from {} to {}", (Object)this.revisionId, (Object)newRevisionId);
            ImmutablePair<Boolean, RemoteFileChangedException> pair = this.policy.onChangeDetected(this.revisionId, newRevisionId, this.uri, pos, operation, this.versionMismatches.get());
            if (((Boolean)pair.left).booleanValue()) {
                this.versionMismatches.incrementAndGet();
            }
            if (pair.right != null) {
                throw (RemoteFileChangedException)((Object)pair.right);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChangeTracker{");
        sb.append("changeDetectionPolicy=").append(this.policy);
        sb.append(", revisionId='").append(this.revisionId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

