/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class FetchSharedConfigurationStatusFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        InternalCache cache = (InternalCache)context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        SharedConfigurationStatus status = locator.getSharedConfigurationStatus().getStatus();
        String memberId = member.getName();
        if (StringUtils.isBlank((CharSequence)memberId)) {
            memberId = member.getId();
        }
        CliFunctionResult result = new CliFunctionResult(memberId, (Object)status.name(), null);
        context.getResultSender().lastResult((Object)result);
    }

    public String getId() {
        return FetchSharedConfigurationStatusFunction.class.getName();
    }
}

