/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Iterator;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class DestroyGatewayReceiverFunction
extends CliFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1490927519860899562L;
    private static final String ID = DestroyGatewayReceiverFunction.class.getName();
    @Immutable
    public static final DestroyGatewayReceiverFunction INSTANCE = new DestroyGatewayReceiverFunction();

    public CliFunctionResult executeFunction(FunctionContext context) {
        Iterator iterator;
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        Set gatewayReceivers = cache.getGatewayReceivers();
        if (gatewayReceivers != null && !gatewayReceivers.isEmpty() && (iterator = gatewayReceivers.iterator()).hasNext()) {
            GatewayReceiver receiver = (GatewayReceiver)iterator.next();
            try {
                if (receiver.isRunning()) {
                    receiver.stop();
                }
                receiver.destroy();
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, String.format("GatewayReceiver destroyed on \"%s\"", memberNameOrId));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new CliFunctionResult(memberNameOrId, (Object)e, "");
            }
        }
        return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.IGNORABLE, "Gateway receiver not found.");
    }

    public String getId() {
        return ID;
    }
}

