/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.ShowMetricsCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;

public class ShowMetricsInterceptor
extends AbstractCliAroundInterceptor {
    @Override
    public ResultModel preExecution(GfshParseResult parseResult) {
        String export_to_report_to = parseResult.getParamValueAsString("file");
        if (export_to_report_to != null && !export_to_report_to.endsWith(".csv")) {
            return ResultModel.createError(CliStrings.format((String)"Invalid file type, the file extension must be \"{0}\"", (Object)".csv"));
        }
        String regionName = parseResult.getParamValueAsString("region");
        String port = parseResult.getParamValueAsString("port");
        String member = parseResult.getParamValueAsString("member");
        String[] categoryArgs = (String[])parseResult.getParamValue("categories");
        if (regionName != null && port != null) {
            return ResultModel.createError("The --region and --port parameters are mutually exclusive. Please only use one or the other.");
        }
        if (port != null && member == null) {
            return ResultModel.createError("If the --port parameter is specified, then the --member parameter must also be specified.");
        }
        if (categoryArgs != null) {
            boolean regionProvided = regionName != null;
            boolean portProvided = port != null;
            boolean memberProvided = member != null;
            List<String> validCategories = ShowMetricsInterceptor.getValidCategoriesAsStrings(regionProvided, memberProvided, portProvided);
            HashSet<String> userCategories = new HashSet<String>(Arrays.asList(categoryArgs));
            userCategories.removeAll(validCategories);
            if (!userCategories.isEmpty()) {
                return this.getInvalidCategoryResult(userCategories);
            }
        }
        return ResultModel.createInfo("OK");
    }

    static List<ShowMetricsCommand.Category> getValidCategories(boolean regionProvided, boolean memberProvided, boolean portProvided) {
        if (regionProvided && memberProvided) {
            return ShowMetricsCommand.REGION_METRIC_CATEGORIES;
        }
        if (regionProvided) {
            return ShowMetricsCommand.SYSTEM_REGION_METRIC_CATEGORIES;
        }
        if (memberProvided && portProvided) {
            return ShowMetricsCommand.MEMBER_WITH_PORT_METRIC_CATEGORIES;
        }
        if (memberProvided) {
            return ShowMetricsCommand.MEMBER_METRIC_CATEGORIES;
        }
        return ShowMetricsCommand.SYSTEM_METRIC_CATEGORIES;
    }

    static List<String> getValidCategoriesAsStrings(boolean regionProvided, boolean memberProvided, boolean portProvided) {
        return ShowMetricsInterceptor.getValidCategories(regionProvided, memberProvided, portProvided).stream().map(Enum::name).collect(Collectors.toList());
    }

    private ResultModel getInvalidCategoryResult(Set<String> invalidCategories) {
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid Categories\n");
        for (String category : invalidCategories) {
            sb.append(category);
            sb.append('\n');
        }
        return ResultModel.createError(sb.toString());
    }

    @Override
    public ResultModel postExecution(GfshParseResult parseResult, ResultModel resultModel, Path tempFile) throws IOException {
        String saveAs = parseResult.getParamValueAsString("file");
        if (saveAs == null) {
            return resultModel;
        }
        File file = new File(saveAs).getAbsoluteFile();
        resultModel.saveFileTo(file.getParentFile());
        return resultModel;
    }
}

