/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.connector.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.connector.sink.DataStructureConverterWrapper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class SinkRuntimeProviderContext
implements DynamicTableSink.Context {
    private final boolean isBounded;

    public SinkRuntimeProviderContext(boolean isBounded) {
        this.isBounded = isBounded;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public TypeInformation<?> createTypeInformation(DataType consumedDataType) {
        DataTypeUtils.validateOutputDataType((DataType)consumedDataType);
        return InternalTypeInfo.of(consumedDataType.getLogicalType());
    }

    public DynamicTableSink.DataStructureConverter createDataStructureConverter(DataType consumedDataType) {
        DataTypeUtils.validateOutputDataType((DataType)consumedDataType);
        return new DataStructureConverterWrapper(DataStructureConverters.getConverter(consumedDataType));
    }
}

