/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.Collector;

public class DeduplicateKeepLastRowFunction
extends KeyedProcessFunctionWithCleanupState<BaseRow, BaseRow, BaseRow> {
    private static final long serialVersionUID = -291348892087180350L;
    private final BaseRowTypeInfo rowTypeInfo;
    private final boolean generateRetraction;
    private ValueState<BaseRow> state;

    public DeduplicateKeepLastRowFunction(long minRetentionTime, long maxRetentionTime, BaseRowTypeInfo rowTypeInfo, boolean generateRetraction) {
        super(minRetentionTime, maxRetentionTime);
        this.rowTypeInfo = rowTypeInfo;
        this.generateRetraction = generateRetraction;
    }

    public void open(Configuration configure) throws Exception {
        super.open(configure);
        if (this.generateRetraction) {
            this.initCleanupTimeState("DeduplicateFunctionKeepLastRow");
            ValueStateDescriptor stateDesc = new ValueStateDescriptor("preRowState", (TypeInformation)this.rowTypeInfo);
            this.state = this.getRuntimeContext().getState(stateDesc);
        }
    }

    public void processElement(BaseRow input, KeyedProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        if (this.generateRetraction) {
            long currentTime = ctx.timerService().currentProcessingTime();
            this.registerProcessingCleanupTimer(ctx, currentTime);
        }
        DeduplicateFunctionHelper.processLastRow(input, this.generateRetraction, this.state, out);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.state});
        }
    }
}

