/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.util;

import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.types.logical.LogicalType;

public final class BaseRowUtil {
    public static final byte ACCUMULATE_MSG = 0;
    public static final byte RETRACT_MSG = 1;

    public static boolean isAccumulateMsg(BaseRow baseRow) {
        return baseRow.getHeader() == 0;
    }

    public static boolean isRetractMsg(BaseRow baseRow) {
        return baseRow.getHeader() == 1;
    }

    public static BaseRow setAccumulate(BaseRow baseRow) {
        baseRow.setHeader((byte)0);
        return baseRow;
    }

    public static BaseRow setRetract(BaseRow baseRow) {
        baseRow.setHeader((byte)1);
        return baseRow;
    }

    public static GenericRow toGenericRow(BaseRow baseRow, LogicalType[] types) {
        if (baseRow instanceof GenericRow) {
            return (GenericRow)baseRow;
        }
        GenericRow row = new GenericRow(baseRow.getArity());
        row.setHeader(baseRow.getHeader());
        for (int i = 0; i < row.getArity(); ++i) {
            if (baseRow.isNullAt(i)) {
                row.setField(i, null);
                continue;
            }
            row.setField(i, TypeGetterSetters.get(baseRow, i, types[i]));
        }
        return row;
    }
}

