/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.SqlTimestamp;

public final class UpdatableRow
implements BaseRow {
    private BaseRow row;
    private final Object[] fields;
    private final boolean[] updated;

    public UpdatableRow(BaseRow row, int arity) {
        this.row = row;
        this.fields = new Object[arity];
        this.updated = new boolean[arity];
    }

    public BaseRow getRow() {
        return this.row;
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public byte getHeader() {
        return this.row.getHeader();
    }

    @Override
    public void setHeader(byte header) {
        this.row.setHeader(header);
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.updated[ordinal] ? this.fields[ordinal] == null : this.row.isNullAt(ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.updated[ordinal] ? ((Boolean)this.fields[ordinal]).booleanValue() : this.row.getBoolean(ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.updated[ordinal] ? ((Byte)this.fields[ordinal]).byteValue() : this.row.getByte(ordinal);
    }

    @Override
    public short getShort(int ordinal) {
        return this.updated[ordinal] ? ((Short)this.fields[ordinal]).shortValue() : this.row.getShort(ordinal);
    }

    @Override
    public int getInt(int ordinal) {
        return this.updated[ordinal] ? ((Integer)this.fields[ordinal]).intValue() : this.row.getInt(ordinal);
    }

    @Override
    public long getLong(int ordinal) {
        return this.updated[ordinal] ? ((Long)this.fields[ordinal]).longValue() : this.row.getLong(ordinal);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.updated[ordinal] ? ((Float)this.fields[ordinal]).floatValue() : this.row.getFloat(ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.updated[ordinal] ? ((Double)this.fields[ordinal]).doubleValue() : this.row.getDouble(ordinal);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return this.updated[ordinal] ? (byte[])this.fields[ordinal] : this.row.getBinary(ordinal);
    }

    @Override
    public BinaryString getString(int ordinal) {
        return this.updated[ordinal] ? (BinaryString)this.fields[ordinal] : this.row.getString(ordinal);
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.updated[ordinal] ? (Decimal)this.fields[ordinal] : this.row.getDecimal(ordinal, precision, scale);
    }

    @Override
    public SqlTimestamp getTimestamp(int ordinal, int precision) {
        return this.updated[ordinal] ? (SqlTimestamp)this.fields[ordinal] : this.row.getTimestamp(ordinal, precision);
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int ordinal) {
        return this.updated[ordinal] ? (BinaryGeneric)this.fields[ordinal] : this.row.getGeneric(ordinal);
    }

    @Override
    public BaseRow getRow(int ordinal, int numFields) {
        return this.updated[ordinal] ? (BaseRow)this.fields[ordinal] : this.row.getRow(ordinal, numFields);
    }

    @Override
    public BaseArray getArray(int ordinal) {
        return this.updated[ordinal] ? (BaseArray)this.fields[ordinal] : this.row.getArray(ordinal);
    }

    @Override
    public BaseMap getMap(int ordinal) {
        return this.updated[ordinal] ? (BinaryMap)this.fields[ordinal] : this.row.getMap(ordinal);
    }

    @Override
    public void setNullAt(int ordinal) {
        this.setField(ordinal, null);
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.setField(ordinal, value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.setField(ordinal, value);
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.setField(ordinal, value);
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.setField(ordinal, value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.setField(ordinal, value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.setField(ordinal, Float.valueOf(value));
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.setField(ordinal, value);
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision) {
        this.setField(ordinal, value);
    }

    @Override
    public void setTimestamp(int ordinal, SqlTimestamp value, int precision) {
        this.setField(ordinal, value);
    }

    public void setField(int ordinal, Object value) {
        this.updated[ordinal] = true;
        this.fields[ordinal] = value;
    }
}

