/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;

public interface BinaryWriter {
    public void reset();

    public void setNullAt(int var1);

    public void writeBoolean(int var1, boolean var2);

    public void writeByte(int var1, byte var2);

    public void writeShort(int var1, short var2);

    public void writeInt(int var1, int var2);

    public void writeLong(int var1, long var2);

    public void writeFloat(int var1, float var2);

    public void writeDouble(int var1, double var2);

    public void writeString(int var1, BinaryString var2);

    public void writeBinary(int var1, byte[] var2);

    public void writeDecimal(int var1, Decimal var2, int var3);

    public void writeTimestamp(int var1, SqlTimestamp var2, int var3);

    public void writeArray(int var1, BaseArray var2, BaseArraySerializer var3);

    public void writeMap(int var1, BaseMap var2, BaseMapSerializer var3);

    public void writeRow(int var1, BaseRow var2, BaseRowSerializer var3);

    public void writeGeneric(int var1, BinaryGeneric var2, BinaryGenericSerializer var3);

    public void complete();

    public static void write(BinaryWriter writer, int pos, Object o, LogicalType type, TypeSerializer serializer) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                writer.writeBoolean(pos, (Boolean)o);
                break;
            }
            case TINYINT: {
                writer.writeByte(pos, (Byte)o);
                break;
            }
            case SMALLINT: {
                writer.writeShort(pos, (Short)o);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                writer.writeInt(pos, (Integer)o);
                break;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                writer.writeLong(pos, (Long)o);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                writer.writeTimestamp(pos, (SqlTimestamp)o, timestampType.getPrecision());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)type;
                writer.writeTimestamp(pos, (SqlTimestamp)o, lzTs.getPrecision());
                break;
            }
            case FLOAT: {
                writer.writeFloat(pos, ((Float)o).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble(pos, (Double)o);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                writer.writeString(pos, (BinaryString)o);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                writer.writeDecimal(pos, (Decimal)o, decimalType.getPrecision());
                break;
            }
            case ARRAY: {
                writer.writeArray(pos, (BaseArray)o, (BaseArraySerializer)serializer);
                break;
            }
            case MAP: 
            case MULTISET: {
                writer.writeMap(pos, (BaseMap)o, (BaseMapSerializer)serializer);
                break;
            }
            case ROW: {
                writer.writeRow(pos, (BaseRow)o, (BaseRowSerializer)serializer);
                break;
            }
            case RAW: {
                writer.writeGeneric(pos, (BinaryGeneric)o, (BinaryGenericSerializer)serializer);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                writer.writeBinary(pos, (byte[])o);
                break;
            }
            default: {
                throw new RuntimeException("Not support type: " + type);
            }
        }
    }
}

