/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.graph.GlobalDataExchangeMode;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

public class ShuffleModeUtils {
    static final String ALL_EDGES_BLOCKING_LEGACY = "batch";
    static final String ALL_EDGES_PIPELINED_LEGACY = "pipelined";

    static GlobalDataExchangeMode getShuffleModeAsGlobalDataExchangeMode(Configuration configuration) {
        String value = configuration.getString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE);
        try {
            return GlobalDataExchangeMode.valueOf((String)ShuffleModeUtils.convertLegacyShuffleMode(value).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported value %s for config %s.", value, ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE.key()));
        }
    }

    private static String convertLegacyShuffleMode(String shuffleMode) {
        switch (shuffleMode.toLowerCase()) {
            case "batch": {
                return GlobalDataExchangeMode.ALL_EDGES_BLOCKING.toString();
            }
            case "pipelined": {
                return GlobalDataExchangeMode.ALL_EDGES_PIPELINED.toString();
            }
        }
        return shuffleMode;
    }
}

