/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.trait.ModifyKind;
import org.apache.flink.table.planner.plan.trait.ModifyKindSet;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKind;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.types.RowKind;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

public final class ChangelogPlanUtils$ {
    public static final ChangelogPlanUtils$ MODULE$;
    private final ChangelogMode FULL_CHANGELOG_MODE;

    static {
        new ChangelogPlanUtils$();
    }

    public ChangelogMode FULL_CHANGELOG_MODE() {
        return this.FULL_CHANGELOG_MODE;
    }

    public boolean inputInsertOnly(StreamPhysicalRel node) {
        return JavaConversions$.MODULE$.asScalaBuffer(node.getInputs()).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelNode x0$1) {
                RelNode relNode = x0$1;
                if (relNode instanceof StreamPhysicalRel) {
                    StreamPhysicalRel streamPhysicalRel = (StreamPhysicalRel)relNode;
                    boolean bl = ChangelogPlanUtils$.MODULE$.isInsertOnly(streamPhysicalRel);
                    return bl;
                }
                throw new MatchError((Object)relNode);
            }
        });
    }

    public boolean isInsertOnly(StreamPhysicalRel node) {
        ModifyKindSetTrait modifyKindSetTrait = node.getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
        return modifyKindSetTrait.modifyKindSet().isInsertOnly();
    }

    public boolean generateUpdateBefore(StreamPhysicalRel node) {
        UpdateKindTrait updateKindTrait = node.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE());
        UpdateKind updateKind = updateKindTrait.updateKind();
        UpdateKind updateKind2 = UpdateKind.BEFORE_AND_AFTER;
        return !(updateKind != null ? !((Object)((Object)updateKind)).equals((Object)updateKind2) : updateKind2 != null);
    }

    public Option<ChangelogMode> getChangelogMode(StreamPhysicalRel node) {
        None$ none$;
        ModifyKindSet modifyKindSet = node.getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE()).modifyKindSet();
        UpdateKind updateKind = node.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE()).updateKind();
        if (modifyKindSet.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Object object;
            ChangelogMode.Builder modeBuilder = ChangelogMode.newBuilder();
            Object object2 = modifyKindSet.contains(ModifyKind.INSERT) ? modeBuilder.addContainedKind(RowKind.INSERT) : BoxedUnit.UNIT;
            Object object3 = modifyKindSet.contains(ModifyKind.DELETE) ? modeBuilder.addContainedKind(RowKind.DELETE) : BoxedUnit.UNIT;
            if (modifyKindSet.contains(ModifyKind.UPDATE)) {
                modeBuilder.addContainedKind(RowKind.UPDATE_AFTER);
                UpdateKind updateKind2 = updateKind;
                UpdateKind updateKind3 = UpdateKind.BEFORE_AND_AFTER;
                object = !(updateKind2 != null ? !((Object)((Object)updateKind2)).equals((Object)updateKind3) : updateKind3 != null) ? modeBuilder.addContainedKind(RowKind.UPDATE_BEFORE) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)modeBuilder.build());
        }
        return none$;
    }

    public String stringifyChangelogMode(Option<ChangelogMode> optionMode) {
        Option<ChangelogMode> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = optionMode;
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = "NONE";
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                ChangelogMode mode = (ChangelogMode)some.x();
                ArrayBuffer kinds = new ArrayBuffer();
                Object object = mode.contains(RowKind.INSERT) ? kinds.$plus$eq((Object)"I") : BoxedUnit.UNIT;
                Object object2 = mode.contains(RowKind.UPDATE_BEFORE) ? kinds.$plus$eq((Object)"UB") : BoxedUnit.UNIT;
                Object object3 = mode.contains(RowKind.UPDATE_AFTER) ? kinds.$plus$eq((Object)"UA") : BoxedUnit.UNIT;
                Object object4 = mode.contains(RowKind.DELETE) ? kinds.$plus$eq((Object)"D") : BoxedUnit.UNIT;
                string = kinds.mkString(",");
            }
            return string;
        }
        throw new MatchError(option);
    }

    private ChangelogPlanUtils$() {
        MODULE$ = this;
        this.FULL_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }
}

